package com.ejianc.business.service;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.bean.WorkEntity;
import com.ejinac.business.vo.WorkAssignVO;
import com.ejinac.business.vo.WorkHistoryVO;
import com.ejinac.business.vo.WorkVO;

import java.util.List;

/**
 * 工作
 * 
 * @author generator
 * 
 */
public interface IWorkService extends IBaseService<WorkEntity> {
    /**
     * 查询数量
     * @param userId
     * @return
     */
    public  CommonResponse<JSONObject> countNumber(Long userId);

    /**
     * 查询我的工作
     * @param queryParam
     * @return
     */
    public IPage<WorkEntity> queryMyList(QueryParam queryParam);

    /**
     * 指派
     * @param workAssignVO
     * @return
     */
    public CommonResponse<String> assignTask(List<WorkAssignVO> workAssignVO);

    /**
     * 处理
     * @param workHistoryVO
     * @return
     */
    public CommonResponse<String> dealTask(WorkHistoryVO workHistoryVO);

    /**
     * 关闭
     * @param workHistoryVO
     * @return
     */
    public CommonResponse<String> closeTask(WorkHistoryVO workHistoryVO);

    /**
     * 查询详情
     * @param id
     * @return
     */
    public WorkVO queryDetail(Long id);

    /**
     * 评论
     * @param workHistoryVO
     * @return
     */
    public CommonResponse<String> commentTask(WorkHistoryVO workHistoryVO);

    /**
     * 根据uuid查询一条数据
     * @param threadUuid
     * @return
     */
    public WorkEntity getByThreadUuid(String threadUuid);

    public CommonResponse<String> pollingTask();
}
