package com.ejianc.business.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bean.WorkEntity;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.mapper.TaskMapper;
import com.ejianc.business.bean.TaskEntity;
import com.ejianc.business.service.ITaskService;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 任务
 * 
 * @author generator
 * 
 */
@Service("taskService")
public class TaskServiceImpl extends BaseServiceImpl<TaskMapper, TaskEntity> implements ITaskService{
    @Autowired
    private TaskMapper taskMapper;

    /**
     * 自定义分页查询
     * @param queryParam
     * @return
     */
    @Override
    public IPage<TaskEntity> queryMyList(QueryParam queryParam) {
        IPage<TaskEntity> page = new Page<TaskEntity>();
        Map<String, Object> param = new HashMap<>();
        param.put("pageIndex", queryParam.getPageIndex());
        param.put("pageSize", queryParam.getPageSize());
        if (queryParam.getParams().get("workItemStr") != null){
            if(queryParam.getParams().get("workItemStr").getValue().equals("1")){
                param.put("workItemStr", "1");
            }else if(queryParam.getParams().get("workItemStr").getValue().equals("0")){
                param.put("workItemStr", "0");
            }
        }
        if (queryParam.getParams().get("workOverdue") != null){
            if(queryParam.getParams().get("workOverdue").getValue().equals("1")){
                param.put("workOverdue", "1");
            }else if(queryParam.getParams().get("workOverdue").getValue().equals("0")){
                param.put("workOverdue", "0");
            }
        }
        if(param.get("pageIndex")!=null){
            Integer pn = queryParam.getPageIndex() - 1 < 0 ? 1 : queryParam.getPageIndex();
            long startLine = (pn - 1) * queryParam.getPageSize();
            param.put("startLine", startLine);
        }
        if(StringUtils.isNotBlank(queryParam.getSearchText())){
            param.put("searchText", queryParam.getSearchText());
        }
        Map<String, Parameter> params = queryParam.getParams();

        /** 数据隔离 本下 */
        //param.put("orgIds",iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList()));

        param.put("userId", InvocationInfoProxy.getUserid());
        param.put("tenantId",InvocationInfoProxy.getTenantid());
        Integer count = taskMapper.countNumber(param);
        if(count>0){
            List<TaskEntity> appEntity = taskMapper.queryMyList(param);
            page.setRecords(appEntity);
        }else{
            page.setRecords(new ArrayList<>());
        }
        if(param.get("pageIndex")!=null){
            page.setCurrent(Integer.parseInt(param.get("pageIndex").toString()));
            page.setSize(Integer.parseInt(param.get("pageSize").toString()));
            page.setTotal(count);
        }
        return page;
    }
}
