package com.ejianc.business.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejinac.business.vo.WorkHistoryVO;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.mapper.WorkHistoryMapper;
import com.ejianc.business.bean.WorkHistoryEntity;
import com.ejianc.business.service.IWorkHistoryService;

import java.util.List;

/**
 * 工作日志
 * 
 * @author generator
 * 
 */
@Service("workHistoryService")
public class WorkHistoryServiceImpl extends BaseServiceImpl<WorkHistoryMapper, WorkHistoryEntity> implements IWorkHistoryService{
    /**
     * 根据workid查询数据
     * @param workId
     * @return
     */
    public List<WorkHistoryVO> queryWorkList(Long workId){
        QueryWrapper<WorkHistoryEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("dr", 0);
        queryWrapper.eq("work_id", workId);
        List<WorkHistoryEntity> list = this.list(queryWrapper);
        return BeanMapper.mapList(list, WorkHistoryVO.class);
    }

}
