package com.ejianc.business.thread;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.bean.TaskEntity;
import com.ejianc.business.bean.WorkEntity;
import com.ejianc.business.service.ITaskService;
import com.ejianc.business.service.IWorkService;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;

import javax.annotation.Resource;
import java.util.List;
import java.util.concurrent.DelayQueue;

/**
 * @author jxy
 * @version 1.0
 * @date 2021/10/8 10:04
 */
@Configuration
public class ThreadTask implements Runnable {
    private static final Logger logger = LogManager.getLogger("threadTask");
    public DelayQueue<WorkTask> workTasksQueue = new DelayQueue<WorkTask>();
    @Autowired
    public IWorkService workService;
    @Autowired
    public ITaskService taskService;

    @Override
    public void run() {
        while (true){
            WorkTask workTask;
            try {
                workTask = workTasksQueue.take();
                logger.info("队列数量----->"+workTasksQueue.size()+"<------");
                taskOut(workTask);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    /**
     * 任务添加到队列中
     * @param uuid
     * @param workTitle
     * @param endTime
     */
    public void taskAdd(String uuid, String workTitle, long endTime) {
        this.taskDelete(uuid);
        WorkTask workTask = new WorkTask(uuid, workTitle, (endTime+60000)+System.currentTimeMillis());
        logger.info(workTitle + "添加到队列"+"------->队列大小"+this.workTasksQueue.size()+"<------");
        this.workTasksQueue.add(workTask);
    }

    /**
     * 任务结束
     * @param workTask
     */
    public void taskOut(WorkTask workTask) {
        WorkEntity workEntity =workService.getByThreadUuid(workTask.getThreadUuid());
        //已完成和已关闭不执行
        if(workEntity != null){
            workEntity.setWhetherOverdue(1);
            workService.updateById(workEntity);
            TaskEntity taskEntity =taskService.getById(workEntity.getPid());
            taskEntity.setWorkOverdue(taskEntity.getWorkOverdue()+1);//逾期项+1
            taskService.updateById(taskEntity);
            logger.info(workTask.getWorkTitle() + "------>结束了<------");
        }
    }

    /**
     * 重队列中删除一个任务
     * @param uuid
     */
    public void taskDelete(String uuid){
        this.workTasksQueue.remove(uuid);
        System.out.println("容量------>"+this.workTasksQueue.size());
        logger.info("容量------>"+this.workTasksQueue.size());
    }
}
