package com.ejianc.business.thread;

import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;

/**
 * @author jxy
 * @version 1.0
 * @date 2021/10/8 10:01
 */
public class WorkTask implements Delayed {
    private String threadUuid;
    private String workTitle;
    //结束时间
    private long endTime;
    private TimeUnit timeUnit = TimeUnit.SECONDS;

    public WorkTask(String threadUuid, String workTitle,long endTime) {
        this.threadUuid = threadUuid;
        this.workTitle = workTitle;
        this.endTime = endTime;
    }

    @Override
    public long getDelay(TimeUnit unit) {
        long flag = this.endTime - System.currentTimeMillis();
        return flag;
    }

    @Override
    public int compareTo(Delayed o) {
        WorkTask workTask = (WorkTask)o;
        long d = this.getDelay(this.timeUnit) - workTask.getDelay(this.timeUnit);
        if (d > 0) {
            return 1;
        } else if (d == 0) {
            return 0;
        } else {
            return -1;
        }
    }

    public String getThreadUuid() {
        return threadUuid;
    }

    public void setThreadUuid(String threadUuid) {
        this.threadUuid = threadUuid;
    }

    public String getWorkTitle() {
        return workTitle;
    }

    public void setWorkTitle(String workTitle) {
        this.workTitle = workTitle;
    }

    public long getEndTime() {
        return endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public TimeUnit getTimeUnit() {
        return timeUnit;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }
}
