package com.ejianc.business.controller;

import java.io.Serializable;

import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejinac.business.vo.WorkAssignVO;
import com.ejinac.business.vo.WorkHistoryVO;
import com.ejinac.business.vo.WorkVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.bean.WorkEntity;
import com.ejianc.business.service.IWorkService;

/**
 * 工作
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("work")
public class WorkController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改
    
    @Autowired
    private IWorkService service; 
    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<WorkVO> saveOrUpdate(@RequestBody WorkVO saveorUpdateVO) {
    	WorkEntity entity = BeanMapper.map(saveorUpdateVO, WorkEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	WorkVO vo = BeanMapper.map(entity, WorkVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<WorkVO> queryDetail(Long id) {
        WorkVO mdClassVo = service.queryDetail(id);
        return CommonResponse.success(mdClassVo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<WorkVO> vos) {
        service.removeByIds(vos.stream().map(WorkVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<WorkVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("workTitle");
        fuzzyFields.add("taskTitle");
        fuzzyFields.add("responsibleUserName");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<WorkEntity> page = service.queryPage(param,false);
        IPage<WorkVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), WorkVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }
    /**
     * 查询列表(分页)
     *
     * @param queryParam
     * @return
     */
    @RequestMapping(value = "/queryMyList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<WorkEntity>> queryMyList(@RequestBody QueryParam queryParam) {
        IPage<WorkEntity> pageData = service.queryMyList(queryParam);
        return CommonResponse.success(pageData);
    }
    /**
     * 查询列表数量(分页)
     *
     * @param queryParam
     * @return
     */
    @RequestMapping(value = "/countNumber", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> countNumber(@RequestParam Long userId) {

        return service.countNumber(userId);
    }

    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("workTitle");
        fuzzyFields.add("taskTitle");
        fuzzyFields.add("responsibleUserName");

        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        IPage<WorkEntity> pageData = service.queryPage(param, false);
        List<WorkVO> voList = new ArrayList<WorkVO>();
        if(CollectionUtils.isNotEmpty(pageData.getRecords())) {
            pageData.getRecords().forEach(pool -> {
                WorkVO r = BeanMapper.map(pool, WorkVO.class);
                if(r.getWhetherOverdue().equals("0")){
                    r.setWhetherOverdueName("否");
                }else{
                    r.setWhetherOverdueName("是");
                }
                voList.add(r);
            });
        }
        String titel="";

        if(param.getParams().get("taskLevel") != null){
            if(param.getParams().get("taskLevel").getValue().equals(2)){
                titel="部门重点报表";
            }else if(param.getParams().get("taskLevel").getValue().equals(1)){
                titel="公司重点报表";
            }else if(param.getParams().get("taskLevel").getValue().equals(3)){
                titel="项目重点报表";
            }
        }else{
            titel="综合报表";
        }

        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("titel",titel);
        beans.put("records", voList);
        ExcelExport.getInstance().export("report-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refWorkData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<WorkVO>> refWorkData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<WorkEntity> page = service.queryPage(param,false);
        IPage<WorkVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), WorkVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }


    /**
     * 指派
     *
     * @param
     * @return
     */
    @RequestMapping(value = "/assignTask", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> assignTask(@RequestBody List<WorkAssignVO> workAssignVO) {
        return service.assignTask(workAssignVO);
    }

    /**
     * 处理
     *
     * @param
     * @return
     */
    @RequestMapping(value = "/dealTask", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> dealTask(@RequestBody WorkHistoryVO workHistoryVO) {
        return service.dealTask(workHistoryVO);
    }

    /**
     * 关闭
     *
     * @param
     * @return
     */
    @RequestMapping(value = "/closeTask", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> closeTask(@RequestBody WorkHistoryVO workHistoryVO) {
        return service.closeTask(workHistoryVO);
    }

    /**
     * 评论
     * @param
     * @return
     */
    @RequestMapping(value = "/commentTask", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> commentTask(@RequestBody WorkHistoryVO workHistoryVO) {
        return service.commentTask(workHistoryVO);
    }
    /**
     * 调度任务
     */
    @RequestMapping(value = "/pollingTask", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> pollingTask() {

        return service.pollingTask();
    }

}
