package com.ejianc.business.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bean.TaskEntity;
import com.ejianc.business.bean.WorkAssignEntity;
import com.ejianc.business.bean.WorkHistoryEntity;
import com.ejianc.business.mapper.WorkAssignMapper;
import com.ejianc.business.service.ITaskService;
import com.ejianc.business.service.IWorkAssignService;
import com.ejianc.business.service.IWorkHistoryService;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejinac.business.vo.WorkAssignVO;
import com.ejinac.business.vo.WorkHistoryVO;
import com.ejinac.business.vo.WorkVO;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.mapper.WorkMapper;
import com.ejianc.business.bean.WorkEntity;
import com.ejianc.business.service.IWorkService;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.*;
import java.util.stream.Collectors;

/**
 * 工作
 * 
 * @author generator
 * 
 */
@Service("workService")
public class WorkServiceImpl extends BaseServiceImpl<WorkMapper, WorkEntity> implements IWorkService{
    private final Logger logger = LoggerFactory.getLogger(getClass());
    @Value("${common.env.base-host}")
    private String baseHost;
    @Autowired
    private WorkAssignMapper workAssignMapper;
    @Autowired
    private IWorkAssignService workAssignService;
    @Autowired
    private IWorkHistoryService workHistoryService;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private ITaskService taskService;

    @Autowired
    private WorkMapper workMapper;
    public final static Integer RUNNING =1;
    public final static Integer FINISH =2;
    public final static Integer CLOSE =3;
    @Autowired
    public IWorkService workService;
    /**
     * 查询数量
     * @param userId
     * @return
     */
    public CommonResponse<JSONObject> countNumber(Long userId) {
        final JSONObject json = new JSONObject();
        Map<String, Object> queryParam = new HashMap<>();
        queryParam.put("responsibleUserId", userId);
        queryParam.put("tenantId", InvocationInfoProxy.getTenantid());
        queryParam.put("orgIds",iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList()));

        queryParam.put("taskStatus", "1");
        Integer running = workAssignMapper.countNumber(queryParam);

        queryParam.put("taskStatus", "2");
        Integer finish = workAssignMapper.countNumber(queryParam);

        queryParam.put("taskStatus", "3");
        Integer close = workAssignMapper.countNumber(queryParam);
        json.put("running",running);
        json.put("finish",finish);
        json.put("close",close);

        return  CommonResponse.success(json);

    }
    //查询我的任务
    @Override
    public IPage<WorkEntity> queryMyList(QueryParam queryParam) {
        IPage<WorkEntity> page = new Page<WorkEntity>();
        Map<String, Object> param = new HashMap<>();
        param.put("pageIndex", queryParam.getPageIndex());
        param.put("pageSize", queryParam.getPageSize());
        if(param.get("pageIndex")!=null){
            Integer pn = queryParam.getPageIndex() - 1 < 0 ? 1 : queryParam.getPageIndex();
            long startLine = (pn - 1) * queryParam.getPageSize();
            param.put("startLine", startLine);
        }
        if(StringUtils.isNotBlank(queryParam.getSearchText())){
            param.put("searchText", queryParam.getSearchText());
        }

        Map<String, Parameter> params = queryParam.getParams();
        if(params!=null){
            for(String key : params.keySet()){
                if("taskStates".equals(key)&&params.get(key).getValue().toString().contains(",")){
                    ////移动端查询方案多选情况
                    param.put("taskStates", params.get(key).getValue().toString().split(","));
                }else{
                    param.put(key, params.get(key).getValue());
                }
            }
        }
        /** 数据隔离 本下 */
        param.put("orgIds",iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList()));

        param.put("userId",InvocationInfoProxy.getUserid());
        param.put("tenantId",InvocationInfoProxy.getTenantid());
        Integer count = workAssignService.countNumber(param);
        if(count>0){
            List<WorkEntity> appEntity = workAssignMapper.queryMyList(param);
            page.setRecords(appEntity);
        }else{
            page.setRecords(new ArrayList<>());
        }
        if(param.get("pageIndex")!=null){
            page.setCurrent(Integer.parseInt(param.get("pageIndex").toString()));
            page.setSize(Integer.parseInt(param.get("pageSize").toString()));
            page.setTotal(count);
        }

        return page;
    }

    /**
     * 指派
     * @param workAssignVO
     * @return
     */
    @Transactional
    public CommonResponse<String> assignTask(List<WorkAssignVO> workAssignVO) {
        try{
            String userName = "";
            String userIds = "";
            String deptNmae ="";
            String deptNmaes ="";

            Long workId =workAssignVO.get(0).getWorkId();
            WorkEntity workEntity = this.getById(workId);
            String[] receivers = new String[workAssignVO.size()];
            for(WorkAssignVO vo : workAssignVO){
                receivers[workAssignVO.indexOf(vo)] = vo.getAssingUserId().toString();
                if(userName.length()>0){
                    userName += ("\n"+vo.getAssingUserName());
                    userIds += ("\n"+vo.getAssingUserId());
                    deptNmae += ("\n"+vo.getAssingDeptNames());
                    deptNmaes += ("\n"+vo.getAssingDeptNames());

                }else{
                    userName += vo.getAssingUserName();
                    userIds += vo.getAssingUserId();
                    deptNmaes+=vo.getAssingDeptNames();
                }

            }
            String[] deptArray = deptNmae.split("\n");
            for (int i=0;i<deptArray.length;i++){
                for(int j=0;j<deptArray.length-1-i;j++) {
                    if(deptArray[j].equals(deptArray[j+1])) {
                        deptNmaes+=deptArray[j+1];
                    }else{
                        deptNmaes+=deptArray[j];
                    }
                }

            }
            workEntity.setAssingUserNames(userName);
            workEntity.setAssingDeptNames(deptNmaes);
            workEntity.setWorkStatus(RUNNING);
            workEntity.setMemo(workAssignVO.get(0).getAssingDescribe());
            this.updateById(workEntity);

            //先删除后添加
            QueryWrapper<WorkAssignEntity> removeWrapper = new QueryWrapper<WorkAssignEntity>();
            removeWrapper.eq("work_id", workId);
            workAssignService.remove(removeWrapper);

            List<WorkAssignEntity> taskUserEntity = BeanMapper.mapList(workAssignVO, WorkAssignEntity.class);
            workAssignService.saveOrUpdateBatch(taskUserEntity);

            //3、新增指派记录
            WorkHistoryEntity entity = new WorkHistoryEntity();
            entity.setWorkId(workId);
            entity.setSolution("指派给"+userName);
            entity.setTaskState(4);
            entity.setWorkDescribe(workAssignVO.get(0).getAssingDescribe());
            workHistoryService.saveOrUpdate(entity , false);

            //发送消息
            logger.info("发送消息开始！===========");
            PushMsgParameter parameter = new PushMsgParameter();
            List<String> channel = new ArrayList<>();
            channel.add(PushMsgParameter.CHANNEL_TYPE_SYS);
            parameter.setChannel(channel.toArray(new String[channel.size()]));// 消息类型
            parameter.setReceivers(receivers);// 收信人
            parameter.setMsgType("notice");
            parameter.setSubject("您有一个新的指派处理：【工作任务指派 】:"+workEntity.getWorkTitle());// 标题
            String url = baseHost + "ejc-gdjgtask-frontend/#/work/workDetail?id="+workEntity.getId();
            parameter.setContent("您有一个新的指派处理：【工作任务指派 】 ："+workEntity.getWorkTitle()+"。<a href="+'"'+url+'"'+">点击查看</a>");// 内容
            parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
            parameter.setSendUserId(InvocationInfoProxy.getUserid());
            try {
                CommonResponse<String> result = pushMessageApi.pushMessage(parameter);
                if (result.isSuccess()) {
                    logger.error("消息发送成功---------------->" + result.getMsg());
                } else {
                    logger.error("消息发送失败---------------->" + result.getMsg());
                }
            } catch (Exception e) {
                logger.error("调用消息中心RPC服务异常--------------" + e);
            }
            return CommonResponse.success("指派成功");
        }catch (Exception e){
            e.printStackTrace();
            return CommonResponse.success("指派失败");
        }
    }




    /**
     * 处理
     * @param workHistoryVO
     * @return
     */
    public CommonResponse<String> dealTask(WorkHistoryVO workHistoryVO) {
        try{

            WorkEntity workEntity = this.getById(workHistoryVO.getWorkId());
            workEntity.setTaskStatus(workHistoryVO.getTaskStatus());
            workEntity.setFeedbackContent(workHistoryVO.getWorkDescribe());
            workEntity.setFeedbackDate(new Date());
            this.saveOrUpdate(workEntity, false);
            //2、新增记录
            WorkHistoryEntity entity = BeanMapper.map(workHistoryVO, WorkHistoryEntity.class);
            entity.setSolution("处理");
            entity.setTaskState(workHistoryVO.getTaskStatus());
            workHistoryService.saveOrUpdate(entity , false);
            if(workEntity.getTaskStatus().equals(FINISH)){
                TaskEntity taskEntity =taskService.getById(workEntity.getPid());
                taskEntity.setWorkItemStatus(taskEntity.getWorkItemStatus()+1);
                taskService.updateById(taskEntity);
            }

            return CommonResponse.success("处理成功");
        }catch (Exception e){
            e.printStackTrace();
            return CommonResponse.success("处理失败");
        }
    }

    /**
     * 关闭
     * @param workHistoryVO
     * @return
     */
    public CommonResponse<String> closeTask(WorkHistoryVO workHistoryVO) {
        try{

            WorkEntity workEntity = this.getById(workHistoryVO.getWorkId());
            if(!workEntity.getWorkStatus().equals(FINISH) && !workEntity.getTaskStatus().equals(CLOSE)){
                TaskEntity taskEntity =taskService.getById(workEntity.getPid());
                taskEntity.setCloseItem(taskEntity.getCloseItem()+1);
                taskService.updateById(taskEntity);
            }

            workEntity.setWorkStatus(CLOSE);//关闭状态
            workEntity.setTaskStatus(CLOSE);//关闭状态
            this.saveOrUpdate(workEntity, false);

            //2、新增记录
            WorkHistoryEntity entity = BeanMapper.map(workHistoryVO, WorkHistoryEntity.class);
            entity.setTaskState(CLOSE);//状态3已关闭
            workHistoryService.saveOrUpdate(entity , false);
            workEntity.setFeedbackContent(workHistoryVO.getWorkDescribe());
            workEntity.setFeedbackDate(new Date());
            return CommonResponse.success("关闭成功");
        }catch (Exception e){
            e.printStackTrace();
            return CommonResponse.success("关闭失败");
        }
    }

    /**
     * 查询详情
     * @param id
     * @return
     */
    public WorkVO queryDetail(Long id) {
        WorkEntity workEntity = this.getById(id);
        WorkVO workVO = BeanMapper.map(workEntity, WorkVO.class);
        List<WorkHistoryVO> historyList = workHistoryService.queryWorkList(id);
        workVO.setWorkHistoryVOList(historyList);
        return workVO;
    }

    /**
     * 评论
     * @param workHistoryVO
     * @return
     */
    @Transactional
    public CommonResponse<String> commentTask(WorkHistoryVO workHistoryVO) {
        try{
            WorkEntity workEntity = this.getById(workHistoryVO.getWorkId());
            WorkHistoryEntity entity = BeanMapper.map(workHistoryVO, WorkHistoryEntity.class);
            //entity.setSolution("操作了督办任务");
            entity.setTaskState(5);
            workEntity.setWorkStatus(5);
            this.updateById(workEntity);
            workHistoryService.saveOrUpdate(entity , false);
            return CommonResponse.success("督办任务成功");
        }catch (Exception e){
            return CommonResponse.success("督办任务失败");
        }
    }

    /**
     * 根据 threadUuid 查询数据
     * @param threadUuid
     * @return
     */
    public WorkEntity getByThreadUuid(String threadUuid) {
        QueryWrapper<WorkEntity> queryWrapper = new QueryWrapper();
        queryWrapper.eq("dr",0);
        queryWrapper.eq("whether_overdue",0);
        queryWrapper.eq("thread_uuid",threadUuid);
        queryWrapper.in("task_status","0,1");
        return workMapper.selectOne(queryWrapper);
    }

    /**
     * 定时任务
     * @return
     */
    public CommonResponse<String> pollingTask() {
        QueryWrapper<WorkEntity> queryWrapper = new QueryWrapper<WorkEntity>();
        queryWrapper.eq("dr",0);
        queryWrapper.eq("whether_overdue",0);
        queryWrapper.in("task_status","0,1");
        List<WorkEntity> list =workService.list(queryWrapper);
        for (WorkEntity entity:list){
            if(entity != null){

                logger.info(">>>>>>>>>>>>>>"+entity.getWorkTitle());

                long time = entity.getAskCompleteDate().getTime()-System.currentTimeMillis();
                if(time <=0){
                    entity.setWhetherOverdue(1);
                    workService.updateById(entity);
                    TaskEntity taskEntity =taskService.getById(entity.getPid());
                    taskEntity.setWorkOverdue(taskEntity.getWorkOverdue()+1);//逾期项+1
                    taskService.updateById(taskEntity);
                }
                logger.info("数据>>>>>>>>>>>>>>"+time);

            }
        }
        return CommonResponse.success("任务执行成功了");
    }

}
