/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bean.TaskEntity;
import com.ejianc.business.bean.WorkAssignEntity;
import com.ejianc.business.bean.WorkEntity;
import com.ejianc.business.bean.WorkHistoryEntity;
import com.ejianc.business.mapper.WorkAssignMapper;
import com.ejianc.business.mapper.WorkMapper;
import com.ejianc.business.service.ITaskService;
import com.ejianc.business.service.IWorkAssignService;
import com.ejianc.business.service.IWorkHistoryService;
import com.ejianc.business.service.IWorkService;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejinac.business.vo.WorkAssignVO;
import com.ejinac.business.vo.WorkHistoryVO;
import com.ejinac.business.vo.WorkVO;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="workService")
public class WorkServiceImpl
extends BaseServiceImpl<WorkMapper, WorkEntity>
implements IWorkService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Autowired
    private WorkAssignMapper workAssignMapper;
    @Autowired
    private IWorkAssignService workAssignService;
    @Autowired
    private IWorkHistoryService workHistoryService;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private ITaskService taskService;
    @Autowired
    private WorkMapper workMapper;
    public static final Integer RUNNING = 1;
    public static final Integer FINISH = 2;
    public static final Integer CLOSE = 3;
    @Autowired
    public IWorkService workService;

    @Override
    public CommonResponse<JSONObject> countNumber(Long userId) {
        JSONObject json = new JSONObject();
        HashMap<String, Object> queryParam = new HashMap<String, Object>();
        queryParam.put("responsibleUserId", userId);
        queryParam.put("tenantId", InvocationInfoProxy.getTenantid());
        queryParam.put("orgIds", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        queryParam.put("taskStatus", "1");
        Integer running = this.workAssignMapper.countNumber(queryParam);
        queryParam.put("taskStatus", "2");
        Integer finish = this.workAssignMapper.countNumber(queryParam);
        queryParam.put("taskStatus", "3");
        Integer close = this.workAssignMapper.countNumber(queryParam);
        json.put("running", (Object)running);
        json.put("finish", (Object)finish);
        json.put("close", (Object)close);
        return CommonResponse.success((Object)json);
    }

    @Override
    public IPage<WorkEntity> queryMyList(QueryParam queryParam) {
        Map params;
        Page page = new Page();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("pageIndex", queryParam.getPageIndex());
        param.put("pageSize", queryParam.getPageSize());
        if (param.get("pageIndex") != null) {
            Integer pn = queryParam.getPageIndex() - 1 < 0 ? 1 : queryParam.getPageIndex();
            long startLine = (pn - 1) * queryParam.getPageSize();
            param.put("startLine", startLine);
        }
        if (StringUtils.isNotBlank((String)queryParam.getSearchText())) {
            param.put("searchText", queryParam.getSearchText());
        }
        if ((params = queryParam.getParams()) != null) {
            for (String key : params.keySet()) {
                if ("taskStates".equals(key) && ((Parameter)params.get(key)).getValue().toString().contains(",")) {
                    param.put("taskStates", ((Parameter)params.get(key)).getValue().toString().split(","));
                    continue;
                }
                param.put(key, ((Parameter)params.get(key)).getValue());
            }
        }
        param.put("orgIds", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        param.put("userId", InvocationInfoProxy.getUserid());
        param.put("tenantId", InvocationInfoProxy.getTenantid());
        Integer count = this.workAssignService.countNumber(param);
        if (count > 0) {
            List<WorkEntity> appEntity = this.workAssignMapper.queryMyList(param);
            page.setRecords(appEntity);
        } else {
            page.setRecords(new ArrayList());
        }
        if (param.get("pageIndex") != null) {
            page.setCurrent((long)Integer.parseInt(param.get("pageIndex").toString()));
            page.setSize((long)Integer.parseInt(param.get("pageSize").toString()));
            page.setTotal((long)count.intValue());
        }
        return page;
    }

    @Override
    @Transactional
    public CommonResponse<String> assignTask(List<WorkAssignVO> workAssignVO) {
        try {
            String userName = "";
            String userIds = "";
            String deptNmae = "";
            String deptNmaes = "";
            Long workId = workAssignVO.get(0).getWorkId();
            WorkEntity workEntity = (WorkEntity)((Object)this.getById(workId));
            String[] receivers = new String[workAssignVO.size()];
            for (WorkAssignVO vo : workAssignVO) {
                receivers[workAssignVO.indexOf((Object)vo)] = vo.getAssingUserId().toString();
                if (userName.length() > 0) {
                    userName = userName + "\n" + vo.getAssingUserName();
                    userIds = userIds + "\n" + vo.getAssingUserId();
                    deptNmae = deptNmae + "\n" + vo.getAssingDeptNames();
                    deptNmaes = deptNmaes + "\n" + vo.getAssingDeptNames();
                    continue;
                }
                userName = userName + vo.getAssingUserName();
                userIds = userIds + vo.getAssingUserId();
                deptNmaes = deptNmaes + vo.getAssingDeptNames();
            }
            String[] deptArray = deptNmae.split("\n");
            for (int i = 0; i < deptArray.length; ++i) {
                for (int j = 0; j < deptArray.length - 1 - i; ++j) {
                    deptNmaes = deptArray[j].equals(deptArray[j + 1]) ? deptNmaes + deptArray[j + 1] : deptNmaes + deptArray[j];
                }
            }
            workEntity.setAssingUserNames(userName);
            workEntity.setAssingDeptNames(deptNmaes);
            workEntity.setWorkStatus(RUNNING);
            workEntity.setMemo(workAssignVO.get(0).getAssingDescribe());
            this.updateById((Object)workEntity);
            QueryWrapper removeWrapper = new QueryWrapper();
            removeWrapper.eq((Object)"work_id", (Object)workId);
            this.workAssignService.remove((Wrapper)removeWrapper);
            List taskUserEntity = BeanMapper.mapList(workAssignVO, WorkAssignEntity.class);
            this.workAssignService.saveOrUpdateBatch(taskUserEntity);
            WorkHistoryEntity entity = new WorkHistoryEntity();
            entity.setWorkId(workId);
            entity.setSolution("\u6307\u6d3e\u7ed9" + userName);
            entity.setTaskState(4);
            entity.setWorkDescribe(workAssignVO.get(0).getAssingDescribe());
            this.workHistoryService.saveOrUpdate((Object)entity, false);
            this.logger.info("\u53d1\u9001\u6d88\u606f\u5f00\u59cb\uff01===========");
            PushMsgParameter parameter = new PushMsgParameter();
            ArrayList<String> channel = new ArrayList<String>();
            channel.add("sys");
            parameter.setChannel(channel.toArray(new String[channel.size()]));
            parameter.setReceivers(receivers);
            parameter.setMsgType("notice");
            parameter.setSubject("\u60a8\u6709\u4e00\u4e2a\u65b0\u7684\u6307\u6d3e\u5904\u7406\uff1a\u3010\u5de5\u4f5c\u4efb\u52a1\u6307\u6d3e \u3011:" + workEntity.getWorkTitle());
            String url = this.baseHost + "ejc-gdjgtask-frontend/#/work/workDetail?id=" + workEntity.getId();
            parameter.setContent("\u60a8\u6709\u4e00\u4e2a\u65b0\u7684\u6307\u6d3e\u5904\u7406\uff1a\u3010\u5de5\u4f5c\u4efb\u52a1\u6307\u6d3e \u3011 \uff1a" + workEntity.getWorkTitle() + "\u3002<a href=" + '\"' + url + '\"' + ">\u70b9\u51fb\u67e5\u770b</a>");
            parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
            parameter.setSendUserId(InvocationInfoProxy.getUserid());
            try {
                CommonResponse result = this.pushMessageApi.pushMessage(parameter);
                if (result.isSuccess()) {
                    this.logger.error("\u6d88\u606f\u53d1\u9001\u6210\u529f---------------->" + result.getMsg());
                } else {
                    this.logger.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25---------------->" + result.getMsg());
                }
            }
            catch (Exception e) {
                this.logger.error("\u8c03\u7528\u6d88\u606f\u4e2d\u5fc3RPC\u670d\u52a1\u5f02\u5e38--------------" + e);
            }
            return CommonResponse.success((String)"\u6307\u6d3e\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            return CommonResponse.success((String)"\u6307\u6d3e\u5931\u8d25");
        }
    }

    @Override
    public CommonResponse<String> dealTask(WorkHistoryVO workHistoryVO) {
        try {
            WorkEntity workEntity = (WorkEntity)((Object)this.getById(workHistoryVO.getWorkId()));
            workEntity.setTaskStatus(workHistoryVO.getTaskStatus());
            workEntity.setFeedbackContent(workHistoryVO.getWorkDescribe());
            workEntity.setFeedbackDate(new Date());
            this.saveOrUpdate((Object)workEntity, false);
            WorkHistoryEntity entity = (WorkHistoryEntity)((Object)BeanMapper.map((Object)workHistoryVO, WorkHistoryEntity.class));
            entity.setSolution("\u5904\u7406");
            entity.setTaskState(workHistoryVO.getTaskStatus());
            this.workHistoryService.saveOrUpdate((Object)entity, false);
            if (workEntity.getTaskStatus().equals(FINISH)) {
                TaskEntity taskEntity = (TaskEntity)((Object)this.taskService.getById(workEntity.getPid()));
                taskEntity.setWorkItemStatus(taskEntity.getWorkItemStatus() + 1);
                this.taskService.updateById((Object)taskEntity);
            }
            return CommonResponse.success((String)"\u5904\u7406\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            return CommonResponse.success((String)"\u5904\u7406\u5931\u8d25");
        }
    }

    @Override
    public CommonResponse<String> closeTask(WorkHistoryVO workHistoryVO) {
        try {
            WorkEntity workEntity = (WorkEntity)((Object)this.getById(workHistoryVO.getWorkId()));
            if (!workEntity.getWorkStatus().equals(FINISH) && !workEntity.getTaskStatus().equals(CLOSE)) {
                TaskEntity taskEntity = (TaskEntity)((Object)this.taskService.getById(workEntity.getPid()));
                taskEntity.setCloseItem(taskEntity.getCloseItem() + 1);
                this.taskService.updateById((Object)taskEntity);
            }
            workEntity.setWorkStatus(CLOSE);
            workEntity.setTaskStatus(CLOSE);
            this.saveOrUpdate((Object)workEntity, false);
            WorkHistoryEntity entity = (WorkHistoryEntity)((Object)BeanMapper.map((Object)workHistoryVO, WorkHistoryEntity.class));
            entity.setTaskState(CLOSE);
            this.workHistoryService.saveOrUpdate((Object)entity, false);
            workEntity.setFeedbackContent(workHistoryVO.getWorkDescribe());
            workEntity.setFeedbackDate(new Date());
            return CommonResponse.success((String)"\u5173\u95ed\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            return CommonResponse.success((String)"\u5173\u95ed\u5931\u8d25");
        }
    }

    @Override
    public WorkVO queryDetail(Long id) {
        WorkEntity workEntity = (WorkEntity)((Object)this.getById(id));
        WorkVO workVO = (WorkVO)BeanMapper.map((Object)((Object)workEntity), WorkVO.class);
        List<WorkHistoryVO> historyList = this.workHistoryService.queryWorkList(id);
        workVO.setWorkHistoryVOList(historyList);
        return workVO;
    }

    @Override
    @Transactional
    public CommonResponse<String> commentTask(WorkHistoryVO workHistoryVO) {
        try {
            WorkEntity workEntity = (WorkEntity)((Object)this.getById(workHistoryVO.getWorkId()));
            WorkHistoryEntity entity = (WorkHistoryEntity)((Object)BeanMapper.map((Object)workHistoryVO, WorkHistoryEntity.class));
            entity.setTaskState(5);
            workEntity.setWorkStatus(5);
            this.updateById((Object)workEntity);
            this.workHistoryService.saveOrUpdate((Object)entity, false);
            return CommonResponse.success((String)"\u7763\u529e\u4efb\u52a1\u6210\u529f");
        }
        catch (Exception e) {
            return CommonResponse.success((String)"\u7763\u529e\u4efb\u52a1\u5931\u8d25");
        }
    }

    @Override
    public WorkEntity getByThreadUuid(String threadUuid) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.eq((Object)"whether_overdue", (Object)0);
        queryWrapper.eq((Object)"thread_uuid", (Object)threadUuid);
        queryWrapper.in((Object)"task_status", new Object[]{"0,1"});
        return (WorkEntity)((Object)this.workMapper.selectOne((Wrapper)queryWrapper));
    }

    @Override
    public CommonResponse<String> pollingTask() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.eq((Object)"whether_overdue", (Object)0);
        queryWrapper.in((Object)"task_status", new Object[]{0, 1});
        List list = this.workService.list((Wrapper)queryWrapper);
        for (WorkEntity entity : list) {
            if (entity == null) continue;
            this.logger.info(">>>>>>>>>>>>>>" + entity.getWorkTitle());
            long time = entity.getAskCompleteDate().getTime() - System.currentTimeMillis();
            if (time <= 0L) {
                entity.setWhetherOverdue(1);
                this.workService.updateById((Object)entity);
                TaskEntity taskEntity = (TaskEntity)((Object)this.taskService.getById(entity.getPid()));
                taskEntity.setWorkOverdue(taskEntity.getWorkOverdue() + 1);
                this.taskService.updateById((Object)taskEntity);
            }
            this.logger.info("\u6570\u636e>>>>>>>>>>>>>>" + time);
        }
        return CommonResponse.success((String)"\u4efb\u52a1\u6267\u884c\u6210\u529f\u4e86");
    }

    @Override
    public CommonResponse<String> warningMessage() {
        this.logger.info("\u8d70\u5230\u4e86....\u5230\u671f\u63d0\u9192");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.in((Object)"bill_state", new Object[]{1, 3});
        queryWrapper.in((Object)"task_status", new Object[]{0, 1});
        List list = this.workService.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (WorkEntity entity : list) {
                int taskDay;
                String weekDate;
                String feedbackDate = df.format(entity.getFeedbackDate() != null ? entity.getFeedbackDate() : new Date());
                if (entity.getFeedbackCycle().equals("1")) {
                    weekDate = WorkServiceImpl.getLastWeeks(feedbackDate);
                    taskDay = this.daysBetween(weekDate);
                    if (taskDay + (entity.getAdvanceCycleReminderNum() != null ? entity.getAdvanceCycleReminderNum() : 0) > 0) continue;
                    this.expireSendMessage(entity, taskDay);
                    continue;
                }
                if (entity.getFeedbackCycle().equals("2")) {
                    weekDate = WorkServiceImpl.getLastMonthDate(feedbackDate, -1);
                    taskDay = this.daysBetween(weekDate);
                    if (taskDay + (entity.getAdvanceCycleReminderNum() != null ? entity.getAdvanceCycleReminderNum() : 0) > 0) continue;
                    this.expireSendMessage(entity, taskDay);
                    continue;
                }
                if (!entity.getFeedbackCycle().equals("3") || (taskDay = this.daysBetween(weekDate = WorkServiceImpl.getLastMonthDate(feedbackDate, -3))) + (entity.getAdvanceCycleReminderNum() != null ? entity.getAdvanceCycleReminderNum() : 0) > 0) continue;
                this.expireSendMessage(entity, taskDay);
            }
        }
        return CommonResponse.success((String)"\u4efb\u52a1\u6267\u884c\u6210\u529f\u4e86");
    }

    public int daysBetween(String askCompleteDate) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String endTime = sdf.format(new Date());
        Calendar cal = Calendar.getInstance();
        long time1 = 0L;
        long time2 = 0L;
        try {
            cal.setTime(sdf.parse(endTime));
            time1 = cal.getTimeInMillis();
            cal.setTime(sdf.parse(askCompleteDate));
            time2 = cal.getTimeInMillis();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        long betweenDays = (time2 - time1) / 86400000L;
        return Integer.parseInt(String.valueOf(betweenDays));
    }

    public void expireSendMessage(WorkEntity entity, int num) {
        boolean flag = true;
        String[] array = this.queryWorkAssignUserId(entity.getId());
        Long responsibleUserId = entity.getResponsibleUserId();
        if (array != null && array.length < 0) {
            for (int i = 0; i < array.length; ++i) {
                if (!array[i].equals(responsibleUserId)) continue;
                flag = false;
            }
            this.sendMessage(entity, array, num);
            if (flag) {
                this.sendResponsibleUserMessage(entity);
            }
        } else {
            this.sendResponsibleUserMessage(entity);
        }
        entity.setFeedbackDate(new Date());
        this.saveOrUpdate((Object)entity);
    }

    private CommonResponse<String> sendMessage(WorkEntity entity, String[] userId, int num) {
        try {
            String url;
            this.logger.info("\u53d1\u9001\u6d88\u606f\u5f00\u59cb\uff01===========");
            PushMsgParameter parameter = new PushMsgParameter();
            ArrayList<String> channel = new ArrayList<String>();
            channel.add("sys");
            parameter.setChannel(channel.toArray(new String[channel.size()]));
            parameter.setReceivers(userId);
            parameter.setMsgType("earlywarn");
            if (num < 0) {
                parameter.setSubject("\u60a8\u6709\u4e00\u4e2a\u4efb\u52a1" + entity.getWorkTitle() + "\u5df2\u7ecf\u8fc7\u671f" + num + "\u5929\u8fc7\u671f\u8bf7\u5c3d\u5feb\u5904\u7406");
                url = this.baseHost + "ejc-gdjgtask-frontend/#/work/workDetail?id=" + entity.getId();
                parameter.setContent("\u60a8\u6709\u4e00\u4e2a\u4efb\u52a1" + entity.getWorkTitle() + "\u5df2\u7ecf\u8fc7\u671f" + num + "\u5929\u8fc7\u671f\u8bf7\u5c3d\u5feb\u5904\u7406\u3002<a href=" + '\"' + url + '\"' + ">\u70b9\u51fb\u67e5\u770b</a>");
            } else {
                parameter.setSubject("\u60a8\u6709\u4e00\u4e2a\u4efb\u52a1" + entity.getWorkTitle() + "\u5230\u5468\u671f\u63d0\u9192");
                url = this.baseHost + "ejc-gdjgtask-frontend/#/work/workDetail?id=" + entity.getId();
                parameter.setContent("\u60a8\u6709\u4e00\u4e2a\u4efb\u52a1" + entity.getWorkTitle() + "\u5230\u5468\u671f\u63d0\u9192\u8bf7\u5c3d\u5feb\u5904\u7406\u3002<a href=" + '\"' + url + '\"' + ">\u70b9\u51fb\u67e5\u770b</a>");
            }
            parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
            parameter.setSendUserId(InvocationInfoProxy.getUserid());
            try {
                CommonResponse result = this.pushMessageApi.pushMessage(parameter);
                if (result.isSuccess()) {
                    this.logger.error("\u6d88\u606f\u53d1\u9001\u6210\u529f---------------->" + result.getMsg() + "---" + entity.getTaskTitle());
                } else {
                    this.logger.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25---------------->" + result.getMsg());
                }
            }
            catch (Exception e) {
                this.logger.error("\u8c03\u7528\u6d88\u606f\u4e2d\u5fc3RPC\u670d\u52a1\u5f02\u5e38--------------" + e);
            }
            return CommonResponse.success((String)"\u6307\u6d3e\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            return CommonResponse.success((String)"\u6307\u6d3e\u5931\u8d25");
        }
    }

    public int daysBetween(String feedbackDate, String createDate) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cal = Calendar.getInstance();
        long time1 = 0L;
        long time2 = 0L;
        try {
            cal.setTime(sdf.parse(createDate));
            time1 = cal.getTimeInMillis();
            cal.setTime(sdf.parse(feedbackDate));
            time2 = cal.getTimeInMillis();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        long betweenDays = (time2 - time1) / 86400000L;
        return Integer.parseInt(String.valueOf(betweenDays));
    }

    public String[] queryWorkAssignUserId(Long workId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"work_id", (Object)workId);
        List list = this.workAssignService.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            String[] receivers = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                WorkAssignEntity entity = (WorkAssignEntity)((Object)list.get(i));
                if (entity.getAssingUserId() == null) continue;
                receivers[i] = entity.getAssingUserId().toString();
            }
            return receivers;
        }
        return null;
    }

    @Override
    public void sendResponsibleUserMessage(WorkEntity workEntity) {
        block5: {
            try {
                String[] receivers = new String[]{workEntity.getResponsibleUserId().toString()};
                this.logger.info("\u53d1\u9001\u6d88\u606f\u5f00\u59cb\uff01===========>");
                PushMsgParameter parameter = new PushMsgParameter();
                ArrayList<String> channel = new ArrayList<String>();
                channel.add("sys");
                parameter.setChannel(channel.toArray(new String[channel.size()]));
                parameter.setReceivers(receivers);
                parameter.setMsgType("notice");
                parameter.setSubject("\u60a8\u6709\u4e00\u4e2a\u65b0\u7684\u4efb\u52a1:" + workEntity.getWorkTitle());
                String url = this.baseHost + "ejc-gdjgtask-frontend/#/work/workDetail?id=" + workEntity.getId();
                parameter.setContent("\u60a8\u6709\u4e00\u4e2a\u65b0\u7684\u4efb\u52a1\uff1a" + workEntity.getWorkTitle() + "\u3002<a href=" + '\"' + url + '\"' + ">\u70b9\u51fb\u67e5\u770b</a>");
                parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
                parameter.setSendUserId(InvocationInfoProxy.getUserid());
                try {
                    CommonResponse result = this.pushMessageApi.pushMessage(parameter);
                    if (result.isSuccess()) {
                        this.logger.error("\u6d88\u606f\u53d1\u9001\u6210\u529f---------------->" + result.getMsg() + "---" + workEntity.getWorkTitle());
                        break block5;
                    }
                    this.logger.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25---------------->" + result.getMsg());
                }
                catch (Exception e) {
                    this.logger.error("\u8c03\u7528\u6d88\u606f\u4e2d\u5fc3RPC\u670d\u52a1\u5f02\u5e38--------------" + e);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void sendResponsibleUserMessage(WorkEntity entity, int askDay) {
        block5: {
            try {
                String[] receivers = new String[]{entity.getResponsibleUserId().toString()};
                this.logger.info("\u53d1\u9001\u6d88\u606f\u5f00\u59cb\uff01===========>");
                PushMsgParameter parameter = new PushMsgParameter();
                ArrayList<String> channel = new ArrayList<String>();
                channel.add("sys");
                parameter.setChannel(channel.toArray(new String[channel.size()]));
                parameter.setReceivers(receivers);
                parameter.setMsgType("notice");
                parameter.setSubject("\u60a8\u6709\u4e00\u4e2a\u4efb\u52a1" + entity.getWorkTitle() + "\u8fd8\u6709" + askDay + "\u5929\u8fc7\u671f\u8bf7\u5c3d\u5feb\u5904\u7406");
                String url = this.baseHost + "ejc-gdjgtask-frontend/#/work/workDetail?id=" + entity.getId();
                parameter.setContent("\u60a8\u6709\u4e00\u4e2a\u4efb\u52a1" + entity.getWorkTitle() + "\u8fd8\u6709" + askDay + "\u5929\u8fc7\u671f\u8bf7\u5c3d\u5feb\u5904\u7406\u3002<a href=" + '\"' + url + '\"' + ">\u70b9\u51fb\u67e5\u770b</a>");
                parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
                parameter.setSendUserId(InvocationInfoProxy.getUserid());
                try {
                    CommonResponse result = this.pushMessageApi.pushMessage(parameter);
                    if (result.isSuccess()) {
                        this.logger.error("\u6d88\u606f\u53d1\u9001\u6210\u529f---------------->" + result.getMsg());
                        break block5;
                    }
                    this.logger.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25---------------->" + result.getMsg());
                }
                catch (Exception e) {
                    this.logger.error("\u8c03\u7528\u6d88\u606f\u4e2d\u5fc3RPC\u670d\u52a1\u5f02\u5e38--------------" + e);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public CommonResponse<String> warningSendMessage(Long workId) {
        block5: {
            String[] array = this.queryWorkAssignUserId(workId);
            WorkEntity workEntity = (WorkEntity)((Object)this.selectById(workId));
            try {
                this.logger.info("\u53d1\u9001\u6d88\u606f\u5f00\u59cb\uff01===========");
                PushMsgParameter parameter = new PushMsgParameter();
                ArrayList<String> channel = new ArrayList<String>();
                channel.add("sys");
                parameter.setChannel(channel.toArray(new String[channel.size()]));
                parameter.setReceivers(array);
                parameter.setMsgType("earlywarn");
                parameter.setSubject("\u60a8\u6709\u4e00\u4e2a\u4efb\u52a1" + workEntity.getWorkTitle() + "\u8d23\u4efb\u4eba\u63d0\u9192\u60a8\u5c3d\u5feb\u5904\u7406");
                String url = this.baseHost + "ejc-gdjgtask-frontend/#/work/workDetail?id=" + workEntity.getId();
                parameter.setContent("\u60a8\u6709\u4e00\u4e2a\u4efb\u52a1" + workEntity.getWorkTitle() + "\u8d23\u4efb\u4eba\u63d0\u9192\u60a8\u5c3d\u5feb\u5904\u7406\u3002<a href=" + '\"' + url + '\"' + ">\u70b9\u51fb\u67e5\u770b</a>");
                parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
                parameter.setSendUserId(InvocationInfoProxy.getUserid());
                try {
                    CommonResponse result = this.pushMessageApi.pushMessage(parameter);
                    if (result.isSuccess()) {
                        this.logger.error("\u6d88\u606f\u53d1\u9001\u6210\u529f---------------->" + result.getMsg());
                        break block5;
                    }
                    this.logger.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25---------------->" + result.getMsg());
                }
                catch (Exception e) {
                    this.logger.error("\u8c03\u7528\u6d88\u606f\u4e2d\u5fc3RPC\u670d\u52a1\u5f02\u5e38--------------" + e);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return CommonResponse.success((String)"\u63d0\u9192\u6210\u529f");
    }

    public static String getLastMonthDate(String dataTime, int num) {
        LocalDate today = LocalDate.parse(dataTime);
        today = today.minusMonths(num);
        return today.toString();
    }

    public static String getLastDayDate(String dataTime, int day) {
        LocalDate today = LocalDate.parse(dataTime);
        today = today.minusDays(day);
        return today.toString();
    }

    public static String getLastWeeks(String dataTime) {
        LocalDate today = LocalDate.parse(dataTime);
        today = today.minusWeeks(-1L);
        return today.toString();
    }

    public static void main(String[] args) {
        System.out.println(WorkServiceImpl.getLastMonthDate("2021-11-24", -1));
    }
}

