/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bean.TaskEntity;
import com.ejianc.business.mapper.TaskMapper;
import com.ejianc.business.service.ITaskService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="taskService")
public class TaskServiceImpl
extends BaseServiceImpl<TaskMapper, TaskEntity>
implements ITaskService {
    @Autowired
    private TaskMapper taskMapper;
    @Autowired
    private IOrgApi iOrgApi;

    @Override
    public IPage<TaskEntity> queryMyList(QueryParam queryParam) {
        Page page = new Page();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("pageIndex", queryParam.getPageIndex());
        param.put("pageSize", queryParam.getPageSize());
        if (queryParam.getParams().get("workItemStr") != null) {
            if (((Parameter)queryParam.getParams().get("workItemStr")).getValue().equals("1")) {
                param.put("workItemStr", "1");
            } else if (((Parameter)queryParam.getParams().get("workItemStr")).getValue().equals("0")) {
                param.put("workItemStr", "0");
            }
        }
        if (queryParam.getParams().get("workOverdue") != null) {
            if (((Parameter)queryParam.getParams().get("workOverdue")).getValue().equals("1")) {
                param.put("workOverdue", "1");
            } else if (((Parameter)queryParam.getParams().get("workOverdue")).getValue().equals("0")) {
                param.put("workOverdue", "0");
            }
        }
        if (queryParam.getOrderMap().get("createTime") != null) {
            param.put("createTime", queryParam.getOrderMap().get("createTime"));
        }
        if (param.get("pageIndex") != null) {
            Integer pn = queryParam.getPageIndex() - 1 < 0 ? 1 : queryParam.getPageIndex();
            long startLine = (pn - 1) * queryParam.getPageSize();
            param.put("startLine", startLine);
        }
        if (StringUtils.isNotBlank((String)queryParam.getSearchText())) {
            param.put("searchText", queryParam.getSearchText());
        }
        Map params = queryParam.getParams();
        param.put("orgIds", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        param.put("userId", InvocationInfoProxy.getUserid());
        param.put("tenantId", InvocationInfoProxy.getTenantid());
        Integer count = this.taskMapper.countNumber(param);
        if (count > 0) {
            List<TaskEntity> appEntity = this.taskMapper.queryMyList(param);
            page.setRecords(appEntity);
        } else {
            page.setRecords(new ArrayList());
        }
        if (param.get("pageIndex") != null) {
            page.setCurrent((long)Integer.parseInt(param.get("pageIndex").toString()));
            page.setSize((long)Integer.parseInt(param.get("pageSize").toString()));
            page.setTotal((long)count.intValue());
        }
        return page;
    }
}

