package com.ejianc.business.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 任务变更
 *
 * @author generator
 *
 */
@TableName("ejc_task_change")
public class TaskChangeEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="code")
    private String code; // 任务编码
    @TableField(value="taks_title")
    private String taksTitle; // 现任务标题
    @TableField(value="year")
    private String year; //
    @TableField(value="promoter_id")
    private Long promoterId; // 发起人
    @TableField(value="promoter_name")
    private String promoterName; // 发起人名称
    @TableField(value="work_item")
    private Integer workItem; // 工作项
    @TableField(value="work_item_status")
    private Integer workItemStatus; // 已完成项
    @TableField(value="work_overdue")
    private Integer workOverdue; // 逾期项
    @TableField(value="initiate_time")
    private java.util.Date initiateTime; // 发起时间
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @TableField(value="close_item")
    private Integer closeItem; //关闭项

    @TableField(exist=false)
    @SubEntity(serviceName = "workChangeService")
    private List<WorkChangeEntity> workItemList = new ArrayList<>();

    @TableField(value="change_user_name")
    private String changeUserName; // 变更人
    /**
     * 变更原因
     */
    @TableField(value = "change_reason")
    private String changeReason;

    @TableField(value="original_task_title")
    private String originalTaskTitle; // 原任务标题
    /**
     * 源计划数据Id
     */
    @TableField(value = "source_task_id")
    private Long sourceTaskId;
    /**
     * 生效日期
     */
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    @TableField(value = "effective_date")
    private Date effectiveDate;
    @TableField(value = "change_version")
    private Integer changeVersion; // 变更版本

    /**
     * 任务编码
     */
    public String getCode() {
        return code;
    }

    /**
     * 任务编码
     */
    public void setCode(String code) {
        this.code = code;
    }
    /**
     * 任务标题
     */
    public String getTaksTitle() {
        return taksTitle;
    }

    /**
     * 任务标题
     */
    public void setTaksTitle(String taksTitle) {
        this.taksTitle = taksTitle;
    }
    /**
     *
     */
    public String getYear() {
        return year;
    }

    /**
     *
     */
    public void setYear(String year) {
        this.year = year;
    }
    /**
     * 发起人
     */
    public Long getPromoterId() {
        return promoterId;
    }

    /**
     * 发起人
     */
    public void setPromoterId(Long promoterId) {
        this.promoterId = promoterId;
    }
    /**
     * 发起人名称
     */
    public String getPromoterName() {
        return promoterName;
    }

    /**
     * 发起人名称
     */
    public void setPromoterName(String promoterName) {
        this.promoterName = promoterName;
    }
    /**
     * 工作项
     */
    public Integer getWorkItem() {
        return workItem;
    }

    /**
     * 工作项
     */
    public void setWorkItem(Integer workItem) {
        this.workItem = workItem;
    }
    /**
     * 已完成项
     */
    public Integer getWorkItemStatus() {
        return workItemStatus;
    }

    public void setWorkItemStatus(Integer workItemStatus) {
        this.workItemStatus = workItemStatus;
    }

    /**
     * 逾期项
     */
    public Integer getWorkOverdue() {
        return workOverdue;
    }

    /**
     * 逾期项
     */
    public void setWorkOverdue(Integer workOverdue) {
        this.workOverdue = workOverdue;
    }
    /**
     * 发起时间
     */
    public java.util.Date getInitiateTime() {
        return initiateTime;
    }

    /**
     * 发起时间
     */
    public void setInitiateTime(java.util.Date initiateTime) {
        this.initiateTime = initiateTime;
    }
    /**
     * 组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public List<WorkChangeEntity> getWorkItemList() {
        return workItemList;
    }

    public void setWorkItemList(List<WorkChangeEntity> workItemList) {
        this.workItemList = workItemList;
    }

    public Integer getCloseItem() {
        return closeItem;
    }

    public void setCloseItem(Integer closeItem) {
        this.closeItem = closeItem;
    }

    public String getChangeUserName() {
        return changeUserName;
    }

    public void setChangeUserName(String changeUserName) {
        this.changeUserName = changeUserName;
    }

    public String getChangeReason() {
        return changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }

    public String getOriginalTaskTitle() {
        return originalTaskTitle;
    }

    public void setOriginalTaskTitle(String originalTaskTitle) {
        this.originalTaskTitle = originalTaskTitle;
    }

    public Long getSourceTaskId() {
        return sourceTaskId;
    }

    public void setSourceTaskId(Long sourceTaskId) {
        this.sourceTaskId = sourceTaskId;
    }

    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }
}
