package com.ejianc.business.bean;

import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 工作日志
 * 
 * @author generator
 * 
 */
 @TableName("ejc_work_history")
public class WorkHistoryEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="task_status")
    private Integer taskStatus; //1--已指派，2--已处理，3--已评论，4--已关闭，5--已完成
    @TableField(value="work_id")
    private Long workId; // 任务id
    @TableField(value="work_describe")
    private String workDescribe; // 任务描述
    @TableField(value="pic_url")
    private String picUrl; // 图片
    @TableField(value="solution")
    private String solution; // 解决方案
    @TableField(value="file_names")
    private String fileNames; // 广东建工任务使用，附件类型，顺序与picUrl对应
    @TableField(value="operator_uesr_id")
    private Long operatorUesrId; // 操作人id
    @TableField(value="operator_uesr_name")
    private String operatorUesrName; // 操作人名称
    @TableField(value="task_state")
    private Integer taskState; //任务状态：0---未开始,1、进行中,2、已完成，3--已关闭，4--指派，5--评论

    /**
     * 任务状态：0---进行中,1、进行中,2、已完成
     */
    public Integer getTaskStatus() {
        return taskStatus;
    }

    public void setTaskStatus(Integer taskStatus) {
        this.taskStatus = taskStatus;
    }

    /**
     * 任务id
     */
    public Long getWorkId() {
        return workId;
    }

    /**
     * 任务id
     */
    public void setWorkId(Long workId) {
        this.workId = workId;
    }
    /**
     * 任务描述
     */
    public String getWorkDescribe() {
        return workDescribe;
    }

    /**
     * 任务描述
     */
    public void setWorkDescribe(String workDescribe) {
        this.workDescribe = workDescribe;
    }
    /**
     * 图片
     */
    public String getPicUrl() {
        return picUrl;
    }

    /**
     * 图片
     */
    public void setPicUrl(String picUrl) {
        this.picUrl = picUrl;
    }
    /**
     * 解决方案
     */
    public String getSolution() {
        return solution;
    }

    /**
     * 解决方案
     */
    public void setSolution(String solution) {
        this.solution = solution;
    }
    /**
     * 广东建工任务使用，附件类型，顺序与picUrl对应
     */
    public String getFileNames() {
        return fileNames;
    }

    /**
     * 广东建工任务使用，附件类型，顺序与picUrl对应
     */
    public void setFileNames(String fileNames) {
        this.fileNames = fileNames;
    }
    /**
     * 操作人id
     */
    public Long getOperatorUesrId() {
        return operatorUesrId;
    }

    /**
     * 操作人id
     */
    public void setOperatorUesrId(Long operatorUesrId) {
        this.operatorUesrId = operatorUesrId;
    }
    /**
     * 操作人名称
     */
    public String getOperatorUesrName() {
        return operatorUesrName;
    }

    /**
     * 操作人名称
     */
    public void setOperatorUesrName(String operatorUesrName) {
        this.operatorUesrName = operatorUesrName;
    }
    /**
     * 1--进行中，2--已指派，3--已评论，4--已关闭，5--已完成
     */
    public Integer getTaskState() {
        return taskState;
    }

    /**
     * 任务状态：0---未开始,1、进行中,2、已完成，3--已关闭，4--指派，5--评论
     */
    public void setTaskState(Integer taskState) {
        this.taskState = taskState;
    }
    
}
