package com.ejianc.business.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bean.*;
import com.ejianc.business.service.*;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejinac.business.vo.TaskChangeVO;
import com.ejinac.business.vo.TaskVO;
import com.ejinac.business.vo.WorkChangeVO;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service("taskChange") 
public class TaskChangeBpmServiceImpl implements ICommonBusinessService {

	private final Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private IBillTypeApi billTypeApi;

    @Autowired
    private ITaskService taskService;

    @Autowired
    private IWorkService workService;

    @Autowired
    private ITaskChangeService taskChangeService;

    @Autowired
    private IWorkChangeService workChangeService;

    @Autowired
    private ITaskChangeHisService taskChangeHisService;

	@Autowired
	private IAttachmentApi attachmentApi;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		TaskChangeEntity taskChange = taskChangeService.getById(billId);
		QueryWrapper<WorkChangeEntity> qw = new QueryWrapper<>();
		qw.eq("pid",taskChange.getId());
		qw.eq("dr",0);
		taskChange.setWorkItemList(workChangeService.list(qw));

		TaskEntity newTaskEntity = null;
		TaskEntity oldTask = taskService.getById(taskChange.getSourceTaskId());
		QueryWrapper<WorkEntity> wrapper = new QueryWrapper<>();
		wrapper.eq("pid",oldTask.getId());
		wrapper.eq("dr",0);
		oldTask.setWorkItemList(workService.list(wrapper));

		//设置任务变更单据生效时间
		taskChange.setEffectiveDate(new Date());
		TaskChangeHisEntity recordEntity = BeanMapper.map(oldTask, TaskChangeHisEntity.class);
		logger.info("任务变更审批正在回调");
		//设置任务Id
		recordEntity.setSourceTaskId(oldTask.getId());
		//Id置为空
		recordEntity.setId(null);
		recordEntity.setId(null);
		if(CollectionUtils.isNotEmpty(recordEntity.getWorkItemList())) {
			recordEntity.getWorkItemList().stream().forEach(detail -> {
				detail.setTargetId(detail.getId());
				detail.setId(null);
			});
		}
		//设置编制人等信息
		recordEntity.setCreateUserCode(taskChange.getCreateUserCode());
		recordEntity.setCreateTime(taskChange.getCreateTime());
		recordEntity.setUpdateTime(taskChange.getUpdateTime());
		recordEntity.setUpdateUserCode(taskChange.getUpdateUserCode());
		recordEntity.setEffectiveDate(taskChange.getEffectiveDate());

		recordEntity.setOriginalTaskTitle(oldTask.getTaksTitle());
		recordEntity.setTaksTitle(taskChange.getTaksTitle());
		recordEntity.setChangeTaskId(oldTask.getCurChangingTaskId());

		recordEntity.setChangeUserName(taskChange.getChangeUserName());
		recordEntity.setChangeReason(taskChange.getChangeReason());

		//任务变更记录保存
		taskChangeHisService.saveOrUpdate(recordEntity, false);

		taskChangeService.saveOrUpdate(taskChange, false);

		//修改总计划字段
		newTaskEntity = BeanMapper.map(taskChange,TaskEntity.class);
		//变更状态-已变更
		newTaskEntity.setChangeState(TaskVO.TASK_CHANGE_STATE_CHANGED);

		//清空当前变更计划id
		newTaskEntity.setCurChangingTaskId(null);
		//合同初始创建信息
		newTaskEntity.setCreateUserCode(oldTask.getCreateUserCode());
		newTaskEntity.setCreateTime(oldTask.getCreateTime());
		newTaskEntity.setId(oldTask.getId());
		newTaskEntity.setVersion(oldTask.getVersion());
		newTaskEntity.setChangeVersion(taskChange.getChangeVersion());

		//子表信息设置
		List<Long> delDetailIds = new ArrayList<>();
		if(CollectionUtils.isNotEmpty(taskChange.getWorkItemList())) {
			List<WorkEntity> list = new ArrayList<>();
			WorkEntity tmp = null;
			Map<Long, Integer> map = oldTask.getWorkItemList().stream().collect(Collectors.toMap(WorkEntity::getId,WorkEntity::getVersion));

			for (WorkChangeEntity detail : taskChange.getWorkItemList()) {
				tmp = BeanMapper.map(detail,WorkEntity.class);
				if(null != detail.getTargetId()) {
					tmp.setId(detail.getTargetId());
					tmp.setVersion(map.get(detail.getTargetId()));
					if(WorkChangeVO.CHANGE_TYPE_DEL.equals(detail.getChangeType())) {
						//终止项删除
						delDetailIds.add(detail.getTargetId());
					} else {
						tmp.setRowState("update");
						list.add(tmp);
					}
				} else {
					tmp.setRowState("add");
					list.add(tmp);
				}
			}
			newTaskEntity.setWorkItemList(list);
		}

		//删除已有子表
		if(CollectionUtils.isNotEmpty(delDetailIds)) {
			workService.delByTaskIdAndDetailIds(delDetailIds, oldTask.getId());
		}

		if(taskService.saveOrUpdate(newTaskEntity, false)){
			logger.info("拷贝附件到任务单据：billId:"+billId+", billTypeCode:"+billTypeCode+", newTaskEntity.getId:"+newTaskEntity.getId());
			//变更单据附件复制到主单据
			attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(billId), "BT202208000004","notOpenApply",String.valueOf(newTaskEntity.getId()),"BT210926000000003","notOpenApply");
			logger.info("回调业务处理成功！");
		}else{
			logger.info("回调业务处理失败！");
		}

		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		if(state != BillStateEnum.COMMITED_STATE.getBillStateCode()) {
			CommonResponse.success("有审批流程的变更任务无法执行该操作！");
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		logger.info("任务变更弃审回调处理：billId: {}, state: {}", billId, state);
		TaskChangeEntity taskChange = taskChangeService.selectById(billId);

		QueryWrapper<TaskChangeHisEntity> hisQuery = new QueryWrapper<>();
		hisQuery.eq("change_task_id", billId);
		TaskChangeHisEntity hisEntity = taskChangeHisService.getOne(hisQuery);

		if(null != hisEntity) {
			//数据恢复至审批完成前的数据状态
			TaskEntity newTaskEntity = null;
			TaskEntity oldTask = taskService.selectById(taskChange.getSourceTaskId());

			logger.info("任务执行弃审数据恢复逻辑，当前数据【{}】，待恢复数据【{}】", oldTask, hisEntity);
			//数据恢复
			newTaskEntity = BeanMapper.map(hisEntity, TaskEntity.class);
			newTaskEntity.setCurChangingTaskId(hisEntity.getChangeTaskId());
			newTaskEntity.setCreateUserCode(oldTask.getCreateUserCode());
			newTaskEntity.setCreateTime(oldTask.getCreateTime());
			newTaskEntity.setId(oldTask.getId());
			newTaskEntity.setVersion(oldTask.getVersion());
			newTaskEntity.setChangeVersion(taskChange.getChangeVersion());

			//变更状态-变更中
			newTaskEntity.setChangeState(TaskVO.TASK_CHANGE_STATE_CHANGING);
			//任务标题
			newTaskEntity.setTaksTitle(hisEntity.getOriginalTaskTitle());
			newTaskEntity.setChangeVersion(taskChange.getChangeVersion() - 1);

			//子表信息设置
			List<Long> delDetailIds = new ArrayList<>();
			if(CollectionUtils.isNotEmpty(taskChange.getWorkItemList())) {
				List<WorkEntity> list = new ArrayList<>();
				WorkEntity tmp = null;
				Map<Long, Integer> map = oldTask.getWorkItemList().stream().collect(Collectors.toMap(WorkEntity::getId,WorkEntity::getVersion));

				for (WorkChangeEntity detail : taskChange.getWorkItemList()) {
					tmp = BeanMapper.map(detail,WorkEntity.class);

					if(null != detail.getTargetId()) {
						tmp.setVersion(map.get(detail.getTargetId()));
						tmp.setId(detail.getTargetId());
						if(detail.getChangeType().equals(WorkChangeVO.CHANGE_TYPE_ADD)) {
							//删除新增项
							delDetailIds.add(detail.getId());
						} else {
							list.add(tmp);
						}
					}else {
						//删除新增项
						delDetailIds.add(detail.getId());
					}
				}
				newTaskEntity.setWorkItemList(list);
			}
			//删除已有子表
			if(CollectionUtils.isNotEmpty(delDetailIds)) {
				workService.delByTaskIdAndDetailIds(delDetailIds, oldTask.getId());
			}

			//删除变更记录
			taskChangeHisService.removeById(hisEntity.getId(), false);

			taskService.saveOrUpdate(newTaskEntity, false);
		}
		if(taskChangeService.saveOrUpdate(taskChange, false)) {
			return CommonResponse.success("回调业务处理成功！");
		}
		return CommonResponse.success("总计划变更弃审回调处理成功！");
	}

}
