package com.ejianc.business.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bean.TaskChangeHisEntity;
import com.ejianc.business.bean.TaskEntity;
import com.ejianc.business.mapper.TaskChangeHisMapper;
import com.ejianc.business.service.ITaskService;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.mapper.TaskChangeMapper;
import com.ejianc.business.bean.TaskChangeEntity;
import com.ejianc.business.service.ITaskChangeService;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 任务变更
 * 
 * @author generator
 * 
 */
@Service("taskChangeService")
public class TaskChangeServiceImpl extends BaseServiceImpl<TaskChangeMapper, TaskChangeEntity> implements ITaskChangeService{

    @Autowired
    private ITaskService taskService;

    @Autowired
    private TaskChangeMapper taskChangeMapper;

    @Autowired
    private TaskChangeHisMapper taskChangeHisMapper;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public TaskChangeEntity saveOrUpdateTaskChange(TaskChangeEntity saveEntity) {
        super.saveOrUpdate(saveEntity, false);
        TaskEntity taskEntity = taskService.selectById(saveEntity.getSourceTaskId());
        if(1 != taskEntity.getChangeState()) {
            taskEntity.setChangeState(1);
            taskEntity.setCurChangingTaskId(saveEntity.getId());
            taskService.saveOrUpdate(taskEntity,false);
        }
        return saveEntity;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteChangeTask(List<Long> changeIds) {
        List<TaskChangeEntity> changeList = taskChangeMapper.selectBatchIds(changeIds);
        List<Long> taskIds = changeList.stream().map(TaskChangeEntity::getSourceTaskId).collect(Collectors.toList());
        QueryWrapper<TaskEntity> taskQuery = new QueryWrapper<>();
        taskQuery.in("id", taskIds);
        List<TaskEntity> taskList = taskService.list(taskQuery);

        //查询已有的变更历史记录
        QueryWrapper<TaskChangeHisEntity> query = new QueryWrapper<>();
        query.select("ifnull(count(1), 0) as hisNum, source_task_id as taskId");
        query.in("source_task_id", taskIds);
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.groupBy("source_task_id");
        List<Map<String, Object>> queryResult = taskChangeHisMapper.selectMaps(query);
        Map<Long, Integer> hisCountNumMap = new HashMap<>();
        queryResult.stream().forEach(m -> {
            hisCountNumMap.put(Long.valueOf(m.get("taskId").toString()), Integer.valueOf(m.get("hisNum").toString()));
        });
        for (TaskEntity task : taskList) {
            task.setChangeState((null !=hisCountNumMap.get(task.getId()) && hisCountNumMap.get(task.getId()) > 0) ? 2 : 0); //未变更
            task.setCurChangingTaskId(null);
        }
        taskService.saveOrUpdateBatch(taskList,taskList.size());

        super.removeByIds(changeList.stream().map(TaskChangeEntity::getId).collect(Collectors.toList()),false);
    }
}
