package com.ejianc.business.controller;

import java.io.Serializable;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejinac.business.vo.WorkHistoryVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.business.bean.WorkHistoryEntity;
import com.ejianc.business.service.IWorkHistoryService;

/**
 * 工作日志
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("workHistory")
public class WorkHistoryController implements Serializable {
	private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IWorkHistoryService service;

    /**
     * @Description updateVO 修改工作描述
     */
    @RequestMapping(value = "/updateHis", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<WorkHistoryVO> updateHis(@RequestBody WorkHistoryVO updateVO) {
    	WorkHistoryEntity entity = BeanMapper.map(updateVO, WorkHistoryEntity.class);
        if(entity.getId()!=null){
            LambdaUpdateWrapper<WorkHistoryEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.eq(WorkHistoryEntity::getId,entity.getId());
            updateWrapper.set(WorkHistoryEntity::getWorkDescribe,entity.getWorkDescribe());
            service.update(updateWrapper);
    	    WorkHistoryVO vo = BeanMapper.map(entity, WorkHistoryVO.class);
    	    return CommonResponse.success("修改任务描述成功！",vo);
        }
    	return CommonResponse.error("修改任务描述失败！");
    }

}
