package com.ejianc.business.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bean.TaskEntity;
import com.ejianc.business.bean.WorkAssignEntity;
import com.ejianc.business.bean.WorkEntity;
import com.ejianc.business.bean.WorkHistoryEntity;
import com.ejianc.business.service.ITaskService;
import com.ejianc.business.service.IWorkAssignService;
import com.ejianc.business.service.IWorkHistoryService;
import com.ejianc.business.service.IWorkService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.List;

@Service("task") 
public class TaskBpmServiceImpl implements ICommonBusinessService {
	private final Logger logger = LoggerFactory.getLogger(getClass());

	@Autowired
	private ITaskService taskService;
	@Autowired
	private IWorkService workService;

	@Autowired
	private IWorkAssignService workAssignService;
	@Autowired
	private IWorkHistoryService workHistoryService;
	
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO

		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		TaskEntity taskEntity =taskService.getById(billId);
		QueryWrapper<WorkEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("pid", billId);
		queryWrapper.eq("dr","0");
		List<WorkEntity> workList=workService.list(queryWrapper);
		for (WorkEntity entity:workList){
			entity.setBillState(state);
			workService.saveOrUpdate(entity);
			workService.sendResponsibleUserMessage(entity);//发送给责任人
		}

		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		TaskEntity taskEntity =taskService.selectById(billId);
        for (WorkEntity workEntity:taskEntity.getWorkItemList()){
        	if(workEntity.getTaskStatus().equals("2")){
        		return CommonResponse.error("存在已完成项目不能撤回");
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		TaskEntity taskEntity =taskService.selectById(billId);
		List<WorkEntity> workList=taskEntity.getWorkItemList();
		for (WorkEntity entity:workList){
			entity.setBillState(state);
			workService.updateById(entity);
			updateAssignUser(entity.getId());
			updateHistory(entity.getId());
			entity.setTaskStatus(0);//恢复到未开始状态
			entity.setWorkStatus(0);//无动作
		}

		return CommonResponse.success();
	}

	/**
	 * 弃审删除指派人
	 * @param workId
	 */
	public void updateAssignUser(Long workId){
		QueryWrapper<WorkAssignEntity> queryWrapper = new QueryWrapper<WorkAssignEntity>();
		queryWrapper.eq("work_id", workId);
		List<WorkAssignEntity> list =workAssignService.list(queryWrapper);
		for (WorkAssignEntity entity:list){
			workAssignService.removeById(entity);//删除指派人
		}
	}

	/**
	 * 删除日志
	 * @param workId
	 */
	public void updateHistory(Long workId){
		QueryWrapper<WorkHistoryEntity> queryWrapper = new QueryWrapper<WorkHistoryEntity>();
		queryWrapper.eq("work_id", workId);
		List<WorkHistoryEntity> list =workHistoryService.list(queryWrapper);
		for (WorkHistoryEntity entity:list){
			workHistoryService.removeById(entity);//删除相关日志
		}
	}
}
