package com.ejianc.business.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bean.TaskChangeHisEntity;
import com.ejianc.business.bean.TaskEntity;
import com.ejianc.business.bean.WorkChangeEntity;
import com.ejianc.business.mapper.TaskChangeHisMapper;
import com.ejianc.business.service.ITaskService;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.DeptVO;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.mapper.TaskChangeMapper;
import com.ejianc.business.bean.TaskChangeEntity;
import com.ejianc.business.service.ITaskChangeService;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 任务变更
 * 
 * @author generator
 * 
 */
@Service("taskChangeService")
public class TaskChangeServiceImpl extends BaseServiceImpl<TaskChangeMapper, TaskChangeEntity> implements ITaskChangeService{

    @Autowired
    private ITaskService taskService;

    @Autowired
    private TaskChangeMapper taskChangeMapper;

    @Autowired
    private TaskChangeHisMapper taskChangeHisMapper;

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IEmployeeApi iEmployeeApi;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public TaskChangeEntity saveOrUpdateTaskChange(TaskChangeEntity saveEntity) {
        super.saveOrUpdate(saveEntity, false);
        TaskEntity taskEntity = taskService.selectById(saveEntity.getSourceTaskId());
        if(1 != taskEntity.getChangeState()) {
            taskEntity.setChangeState(1);
            taskEntity.setCurChangingTaskId(saveEntity.getId());
            taskService.saveOrUpdate(taskEntity,false);
        }
        return saveEntity;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteChangeTask(List<Long> changeIds) {
        List<TaskChangeEntity> changeList = taskChangeMapper.selectBatchIds(changeIds);
        List<Long> taskIds = changeList.stream().map(TaskChangeEntity::getSourceTaskId).collect(Collectors.toList());
        QueryWrapper<TaskEntity> taskQuery = new QueryWrapper<>();
        taskQuery.in("id", taskIds);
        List<TaskEntity> taskList = taskService.list(taskQuery);

        //查询已有的变更历史记录
        QueryWrapper<TaskChangeHisEntity> query = new QueryWrapper<>();
        query.select("ifnull(count(1), 0) as hisNum, source_task_id as taskId");
        query.in("source_task_id", taskIds);
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.groupBy("source_task_id");
        List<Map<String, Object>> queryResult = taskChangeHisMapper.selectMaps(query);
        Map<Long, Integer> hisCountNumMap = new HashMap<>();
        queryResult.stream().forEach(m -> {
            hisCountNumMap.put(Long.valueOf(m.get("taskId").toString()), Integer.valueOf(m.get("hisNum").toString()));
        });
        for (TaskEntity task : taskList) {
            task.setChangeState((null !=hisCountNumMap.get(task.getId()) && hisCountNumMap.get(task.getId()) > 0) ? 2 : 0); //未变更
            task.setCurChangingTaskId(null);
        }
        taskService.saveOrUpdateBatch(taskList,taskList.size());

        super.removeByIds(changeList.stream().map(TaskChangeEntity::getId).collect(Collectors.toList()),false);
    }

    @Override
    public WorkChangeEntity saveOrgId(WorkChangeEntity workEntity) {
        //如果组织为空
        if(workEntity.getOrgId()==null){
            //部门不为空
            if(StringUtils.isNotBlank(workEntity.getResponsibleDepId())){
                List<Long> orgIds = new ArrayList<>();
                List<String> orgIdStr = new ArrayList<>();
                List<String> orgNames = new ArrayList<>();
                String[] split = workEntity.getResponsibleDepId().split(",");
                //根据部门id查询部门
                for (String s : split) {
                    CommonResponse<DeptVO> deptById = iOrgApi.findDeptById(Long.valueOf(s));
                    if(deptById.isSuccess()){
                        orgIdStr.add(String.valueOf(deptById.getData().getOrgId()));
                        //获取部门中的组织id
                        orgIds.add(deptById.getData().getOrgId());
                    }
                }
                //根据组织id查询组织名称
                for (Long orgId : orgIds) {
                    CommonResponse<OrgVO> oneById = iOrgApi.getOneById(orgId);
                    if(oneById.isSuccess()){
                        orgNames.add(oneById.getData().getName());
                    }
                }
                if(CollectionUtils.isNotEmpty(orgIdStr)){
                    orgIdStr = orgIdStr.stream().distinct().collect(Collectors.toList());
                    workEntity.setOrgId(StringUtils.join(orgIdStr.toArray(),","));
                }
                if(CollectionUtils.isNotEmpty(orgNames)){
                    orgNames = orgNames.stream().distinct().collect(Collectors.toList());
                    workEntity.setOrgName(StringUtils.join(orgNames.toArray(), ","));
                }
            }else{
                //部门为空，根据责任人查
                List<String> orgIds = new ArrayList<>();
                List<String> orgNames = new ArrayList<>();
                String[] split = workEntity.getResponsibleUserId().split(",");
                //查询责任人的组织id 组织名称
                for (String s : split) {
                    CommonResponse<EmployeeVO> employeeVOCommonResponse = iEmployeeApi.queryEmployeByUserId(Long.valueOf(s));
                    if(employeeVOCommonResponse.isSuccess()){
                        orgIds.add(String.valueOf(employeeVOCommonResponse.getData().getOrgId()));
                        orgNames.add(employeeVOCommonResponse.getData().getOrgName());
                    }
                }
                if(CollectionUtils.isNotEmpty(orgIds)){
                    orgIds = orgIds.stream().distinct().collect(Collectors.toList());
                    workEntity.setOrgId(StringUtils.join(orgIds.toArray(),","));
                }
                if(CollectionUtils.isNotEmpty(orgNames)){
                    orgNames = orgNames.stream().distinct().collect(Collectors.toList());
                    workEntity.setOrgName(StringUtils.join(orgNames.toArray(), ","));
                }
            }
        }
        return workEntity;
    }
}
