package com.ejianc.business.guarantee.enums;


import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 担保合同状态
 *
 * @author Jiang
 * @Description:
 * @date 2023年3月30日11:01:11
 */
public enum ContractStatuesEnum {
    签订中(0, "签订中"),
    在保(1, "在保"),
    解保(2, "解保"),
    已结束(3,"已结束"),
    已关闭(4, "已关闭"),


    续保中(1, "续保中"),
    已续保(2, "已续保"),


    追偿中(1, "追偿中"),
    已追偿(2, "已追偿"),


    未到账(0,"未到账"),
    已全部到账(1,"已全部到账"),
    未完全到账(2,"未完全到账");


    private Integer code;
    private String description;
    private static Map<Integer, ContractStatuesEnum> enumMap = new HashMap<>();

    ContractStatuesEnum(Integer code, String description) {
        this.code = code;
        this.description = description;
    }

    public Integer getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

    static {
        enumMap = EnumSet.allOf(ContractStatuesEnum.class).stream().collect(Collectors.toMap(ContractStatuesEnum::getCode, Function.identity(), (k1, k2) -> k2));
    }

    public static ContractStatuesEnum getEnumByCode(Integer billStateCode) {
        return enumMap.get(billStateCode);
    }

    }
