package com.ejianc.business.guarantee.contract.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 续保财务确认信息
 * 
 * @author generator
 * 
 */
public class RenewalFinanceVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编码
    private Long orgId; // 组织id
    private String orgName; // 组织名称
    private Integer billState; // 单据状态（审批必须字段）
    private String createUserName; // 编制人
    private Long operatorId; // 经办人ID
    private String operatorName; // 经办人姓名
    private String updateUserName; // 修改者
    private String renewalRemark; // 备注
    private Long renewalId; // 解保id
    private BigDecimal renewalMny; // 保费金额
    private Integer isReceive; // 是否到账(1-是 2-否)
    private Long contractId; // 合同id
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }
    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }

    public String getRenewalRemark() {
        return renewalRemark;
    }

    public void setRenewalRemark(String renewalRemark) {
        this.renewalRemark = renewalRemark;
    }
    @ReferSerialTransfer(referCode="ref-guarantee-renewal")
    public Long getRenewalId() {
        return renewalId;
    }
    @ReferDeserialTransfer
    public void setRenewalId(Long renewalId) {
        this.renewalId = renewalId;
    }

    public BigDecimal getRenewalMny() {
        return renewalMny;
    }

    public void setRenewalMny(BigDecimal renewalMny) {
        this.renewalMny = renewalMny;
    }

    public Integer getIsReceive() {
        return isReceive;
    }

    public void setIsReceive(Integer isReceive) {
        this.isReceive = isReceive;
    }

    @ReferSerialTransfer(referCode="ref-guarantee-contract")
    public Long getContractId() {
        return contractId;
    }
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    
}
