package com.ejianc.business.guarantee.contract.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 担保合同续保
 * 
 * @author generator
 * 
 */
public class RenewalVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编码
    private Long orgId; // 组织id
    private String orgName; // 组织名称
    private Integer billState; // 单据状态（审批必须字段）
    private String createUserName; // 编制人
    private Long operatorId; // 经办人ID
    private String operatorName; // 经办人姓名
    private String updateUserName; // 修改者
    private String renewalRemark; // 备注
    private BigDecimal premiumMny; // 保费金额
    private BigDecimal premiumTaxMny; // 保费金额(含税)
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date renewalStartDate; // 续保开始日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date renewalEndDate; // 续保结束日期
    private Integer renewalNum; // 续保次数
    private Long contractId; // 担保合同id
    private String contractName; // 合同名称
    private Long projectId; // 项目
    private String projectName; // 项目名称
    private String renewalName;//续保名称

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }
    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }

    public String getRenewalRemark() {
        return renewalRemark;
    }

    public void setRenewalRemark(String renewalRemark) {
        this.renewalRemark = renewalRemark;
    }

    public BigDecimal getPremiumMny() {
        return premiumMny;
    }

    public void setPremiumMny(BigDecimal premiumMny) {
        this.premiumMny = premiumMny;
    }
    public BigDecimal getPremiumTaxMny() {
        return premiumTaxMny;
    }

    public void setPremiumTaxMny(BigDecimal premiumTaxMny) {
        this.premiumTaxMny = premiumTaxMny;
    }

    public Date getRenewalStartDate() {
        return renewalStartDate;
    }

    public void setRenewalStartDate(Date renewalStartDate) {
        this.renewalStartDate = renewalStartDate;
    }

    public Date getRenewalEndDate() {
        return renewalEndDate;
    }

    public void setRenewalEndDate(Date renewalEndDate) {
        this.renewalEndDate = renewalEndDate;
    }
    @ReferSerialTransfer(referCode="ref-guarantee-contract")
    public Long getContractId() {
        return contractId;
    }
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public Integer getRenewalNum() {
        return renewalNum;
    }

    public void setRenewalNum(Integer renewalNum) {
        this.renewalNum = renewalNum;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getRenewalName() {
        return renewalName;
    }

    public void setRenewalName(String renewalName) {
        this.renewalName = renewalName;
    }
}
