package com.ejianc.business.guarantee.enums;


import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 担保合同状态
 *
 * @author Jiang
 * @Description:
 * @date 2023年3月30日11:01:11
 */
public enum ProjectReviewStatuesEnum {
    跟踪中(1, "跟踪中"),
    评审中(2, "评审中"),
    评审结束(3,"评审结束"),
    已中止(4,"已中止");



    private Integer code;
    private String description;
    private static Map<Integer, ProjectReviewStatuesEnum> enumMap = new HashMap<>();

    ProjectReviewStatuesEnum(Integer code, String description) {
        this.code = code;
        this.description = description;
    }

    public Integer getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

    static {
        enumMap = EnumSet.allOf(ProjectReviewStatuesEnum.class).stream().collect(Collectors.toMap(ProjectReviewStatuesEnum::getCode, Function.identity(), (k1, k2) -> k2));
    }

    public static ProjectReviewStatuesEnum getEnumByCode(Integer billStateCode) {
        return enumMap.get(billStateCode);
    }

    }
