package com.ejianc.business.proother.contract.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.proother.contract.bean.ContractEntity;
import com.ejianc.business.proother.contract.service.IContractService;
import com.ejianc.business.proother.contract.vo.ContractVO;
import com.ejianc.business.tender.common.vo.SignContractVo;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

/**
 * @author CJ
 * @Description:
 * @date 2022/7/16 10:56
 */
@RestController
@RequestMapping
public class OtherContractApiController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IContractService contractService;

    /**
     * 根据招标id查询合同集合
     * @param targetResultIdList
     * @return
     */
    @GetMapping(value = "/api/contract/queryContractByTargetResultId")
    @ResponseBody
    CommonResponse<List<SignContractVo>> queryContractByTargetResultId(@RequestParam(value = "targetResultIdList") List<String> targetResultIdList){
        if (CollectionUtils.isNotEmpty(targetResultIdList)){
            logger.info("接收定标id集合数据：{}", JSONObject.toJSONString(targetResultIdList));
            List<SignContractVo> resp = new ArrayList<>();
            QueryWrapper<ContractEntity> query = new QueryWrapper<>();
            query.in("target_result_id", targetResultIdList);

            List<ContractEntity> entities = contractService.list(query);
            entities.forEach(contractEntity -> {
                SignContractVo signContractVo = new SignContractVo();
                signContractVo.setBillCode(contractEntity.getBillCode());
                signContractVo.setBillState(contractEntity.getBillState());
                signContractVo.setContractId(contractEntity.getId());
                signContractVo.setContractTaxMny(contractEntity.getContractTaxMny());
                signContractVo.setContractMny(contractEntity.getContractMny());
                signContractVo.setContractName(contractEntity.getContractName());
                signContractVo.setSignDate(contractEntity.getSignDate());
                signContractVo.setSupplierId(contractEntity.getSupplierId());
                signContractVo.setSupplierName(contractEntity.getSupplierName());
                signContractVo.setLinkUrl(contractService.getLinkUrl(BeanMapper.map(contractEntity, ContractVO.class)));

                resp.add(signContractVo);
            });

            return CommonResponse.success("根据招标id查询合同集合成功！", resp);
        }else {
            return CommonResponse.error("请传入正确的定标id集参数！");
        }
    }

}
