package com.ejianc.business.guarantee.contract.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.guarantee.contract.bean.ContractEntity;
import com.ejianc.business.guarantee.contract.bean.RenewalEntity;
import com.ejianc.business.guarantee.contract.bean.RenewalFinanceEntity;
import com.ejianc.business.guarantee.contract.service.IContractService;
import com.ejianc.business.guarantee.contract.service.IRenewalFinanceService;
import com.ejianc.business.guarantee.contract.service.IRenewalService;
import com.ejianc.business.guarantee.enums.ContractStatuesEnum;
import com.ejianc.framework.auth.session.SessionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;

@Service("renewalFinance") 
public class RenewalFinanceBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private SessionManager sessionManager;

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IContractService contractService;

	@Autowired
	private IRenewalService renewalService;

	@Autowired
	private IRenewalFinanceService service;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		RenewalFinanceEntity renewalFinanceEntity = service.selectById(billId);
		if(renewalFinanceEntity != null){

			RenewalEntity renewalEntity = renewalService.selectById(renewalFinanceEntity.getRenewalId());//担保合同续保
			if(renewalEntity != null){
//				BigDecimal premiumMny = renewalEntity.getPremiumMny();//保费金额 }
//				BigDecimal totalRenewalMny = BigDecimal.ZERO;//总到账的保费金额
//				ContractEntity contractEntity = contractService.selectById(renewalEntity.getContractId());//担保合同评审
//
//				/**
//				 * 查询条件:
//				 * 		1.续保id
//				 * 		2.未删除
//				 * 		3.已提交，审批通过
//				 * 		4.已到账
//				 * 业务描述:
//				 * 		遍历查询出的数据，将保费金额累加，与保费金额比较
//				 * 		相等时将续保状态改为已续保，合同状态更改为在保
//				 */
//				List<RenewalFinanceEntity> list = service.list(Wrappers.<RenewalFinanceEntity>lambdaQuery()
//						.eq(RenewalFinanceEntity::getRenewalId, renewalFinanceEntity.getRenewalId())
//						.eq(RenewalFinanceEntity::getDr, 0)
//						.in(RenewalFinanceEntity::getBillState, Arrays.asList(1, 3))
//						.eq(RenewalFinanceEntity::getIsReceive, 1)
//				);
//				for (RenewalFinanceEntity financeEntity : list) {
//					if (financeEntity.getRenewalMny() != null){
//						totalRenewalMny = totalRenewalMny.add(financeEntity.getRenewalMny());
//					} else {
//						return CommonResponse.error("系统错误，请联系管理员！(存在保费金额为null)");
//					}
//				}
//				if(totalRenewalMny.compareTo(premiumMny) == 0){
//					contractEntity.setRenewalStatus(ContractStatuesEnum.已续保.getCode());
//					contractEntity.setContractStatus(ContractStatuesEnum.在保.getCode());
//					contractService.saveOrUpdate(contractEntity);
//				}
				ContractEntity contractEntity = contractService.selectById(renewalEntity.getContractId());//担保合同评审
				contractEntity.setRenewalStatus(ContractStatuesEnum.已续保.getCode());
				contractEntity.setContractStatus(ContractStatuesEnum.在保.getCode());
				contractService.saveOrUpdate(contractEntity);
			}
			return CommonResponse.success();

		}
		return CommonResponse.error("系统错误,请联系管理员！");
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
