/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.guarantee.projectReview.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.guarantee.projectReview.bean.ProjectReviewEntity;
import com.ejianc.business.guarantee.projectReview.mapper.ProjectReviewMapper;
import com.ejianc.business.guarantee.projectReview.service.IProjectReviewService;
import com.ejianc.business.guarantee.supplier.bean.SupplierEntity;
import com.ejianc.business.guarantee.supplier.service.ISupplierService;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.vo.AdministrativeAreaVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.share.vo.dto.SupplierDTO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="projectReviewService")
public class ProjectReviewServiceImpl
extends BaseServiceImpl<ProjectReviewMapper, ProjectReviewEntity>
implements IProjectReviewService {
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private ISupplierService supplierService;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ProjectReviewMapper projectReviewMapper;

    @Override
    public void saveSupplier(ProjectReviewEntity entity) {
        Long supplierId = entity.getSupplierId();
        SupplierEntity localEntity = (SupplierEntity)((Object)this.supplierService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getDr, (Object)0)).eq(SupplierEntity::getSupplierId, (Object)supplierId)));
        SupplierDTO supplierDTO = (SupplierDTO)this.proSupplierApi.selectById(supplierId).getData();
        if (supplierDTO != null) {
            SupplierEntity supplierEntity = new SupplierEntity();
            if (localEntity != null) {
                supplierEntity = localEntity;
            }
            supplierEntity.setSupplierId(supplierDTO.getId());
            supplierEntity.setSupplierName(supplierDTO.getName());
            supplierEntity.setBeginDate(supplierDTO.getRegisterTime());
            supplierEntity.setLegalPersonName(supplierDTO.getLegal());
            supplierEntity.setRegisterMny(supplierDTO.getRegisteredCapital());
            supplierEntity.setOrgId(entity.getOrgId());
            supplierEntity.setOrgName(entity.getOrgName());
            SupplierVO supplierVO = (SupplierVO)BeanMapper.map((Object)((Object)supplierEntity), SupplierVO.class);
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)supplierVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c\u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            supplierEntity.setBillCode((String)billCode.getData());
            this.supplierService.saveOrUpdate((Object)supplierEntity);
        }
    }

    @Override
    public List<AdministrativeAreaVO> queryAreaList() {
        return this.projectReviewMapper.queryAreaList();
    }
}

