package com.ejianc.business.guarantee.projectReview.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 项目评审
 * 
 * @author generator
 * 
 */
 @TableName("ejc_guarantee_project_review")
public class ProjectReviewEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="create_user_name")
    private String createUserName; // 编制人
    @TableField(value="operator_id")
    private Long operatorId; // 经办人ID
    @TableField(value="operator_name")
    private String operatorName; // 经办人姓名
    @TableField(value="update_user_name")
    private String updateUserName; // 修改者
    @TableField(value="remark")
    private String remark; // 备注
    @TableField(value="supplier_id")
    private Long supplierId; // 供应商id
    @TableField(value="supplier_name")
    private String supplierName; // 供应商名称
    @TableField(value="register_mny")
    private BigDecimal registerMny; // 注册资金
    @TableField(value="litigation_cases")
    private Integer litigationCases; // 诉讼案件（1：较多 2：较少 3：无）
    @TableField(value="legal_person_name")
    private String legalPersonName; // 法定代表人名称
    @TableField(value="begin_date")
    private Date beginDate; // 成立时间
    @TableField(value="quality_level_name")
    private String qualityLevelName; // 资质等级
    @TableField(value="project_id")
    private Long projectId; // 项目
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="apply_area")
    private String applyArea; // 申请地区
    @TableField(value="apply_area_name")
    private String applyAreaName; // 申请地区名称
    @TableField(value="employee_id")
    private Long employeeId; // 委托保证人
    @TableField(value="employee_name")
    private String employeeName; // 委托保证人名称
    @TableField(value="start_date")
    private Date startDate; // 开工日期
    @TableField(value="end_date")
    private Date endDate; // 竣工日期
    @TableField(value="duration")
    private String duration; // 工期
    @TableField(value="contract_mny")
    private BigDecimal contractMny; // 合同造价(无税)
    @TableField(value="contract_tax_mny")
    private BigDecimal contractTaxMny; // 合同造价(含税)
    @TableField(value="owner")
    private Long owner; // 业主
    @TableField(value="owner_name")
    private String ownerName; // 业主名称
    @TableField(value="contractor_id")
    private Long contractorId; // 承包商
    @TableField(value="contractor_name")
    private String contractorName; // 承包商名称
    @TableField(value="applicant")
    private Long applicant; // 申请人
    @TableField(value="applicant_name")
    private String applicantName; // 申请名称
    @TableField(value="guarantee_type")
    private Long guaranteeType; // 担保类型
    @TableField(value="guarantee_type_name")
    private String guaranteeTypeName; // 担保类型名称
    @TableField(value = "follow_status")
    private Integer followStatus;//跟踪状态(1-跟踪中 2-评审中 3-评审结束)
    @TableField(value="guarantee_tax_mny")
    private BigDecimal guaranteeTaxMny; // 担保金额
    @TableField(value="guarantee_mny_per")
    private BigDecimal guaranteeMnyPer; // 担保额比例
    @TableField(value = "approve_date")
    private Date approveDate; //审批通过时间

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }
    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public BigDecimal getRegisterMny() {
        return registerMny;
    }

    public void setRegisterMny(BigDecimal registerMny) {
        this.registerMny = registerMny;
    }
    public Integer getLitigationCases() {
        return litigationCases;
    }

    public void setLitigationCases(Integer litigationCases) {
        this.litigationCases = litigationCases;
    }
    public String getLegalPersonName() {
        return legalPersonName;
    }

    public void setLegalPersonName(String legalPersonName) {
        this.legalPersonName = legalPersonName;
    }
    public Date getBeginDate() {
        return beginDate;
    }

    public void setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
    }
    public String getQualityLevelName() {
        return qualityLevelName;
    }

    public void setQualityLevelName(String qualityLevelName) {
        this.qualityLevelName = qualityLevelName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getApplyArea() {
        return applyArea;
    }

    public void setApplyArea(String applyArea) {
        this.applyArea = applyArea;
    }
    public String getApplyAreaName() {
        return applyAreaName;
    }

    public void setApplyAreaName(String applyAreaName) {
        this.applyAreaName = applyAreaName;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }
    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }
    public String getDuration() {
        return duration;
    }

    public void setDuration(String duration) {
        this.duration = duration;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    public Long getOwner() {
        return owner;
    }

    public void setOwner(Long owner) {
        this.owner = owner;
    }
    public String getOwnerName() {
        return ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }
    public Long getContractorId() {
        return contractorId;
    }

    public void setContractorId(Long contractorId) {
        this.contractorId = contractorId;
    }
    public String getContractorName() {
        return contractorName;
    }

    public void setContractorName(String contractorName) {
        this.contractorName = contractorName;
    }
    public Long getApplicant() {
        return applicant;
    }

    public void setApplicant(Long applicant) {
        this.applicant = applicant;
    }
    public String getApplicantName() {
        return applicantName;
    }

    public void setApplicantName(String applicantName) {
        this.applicantName = applicantName;
    }
    public Long getGuaranteeType() {
        return guaranteeType;
    }

    public void setGuaranteeType(Long guaranteeType) {
        this.guaranteeType = guaranteeType;
    }
    public String getGuaranteeTypeName() {
        return guaranteeTypeName;
    }

    public void setGuaranteeTypeName(String guaranteeTypeName) {
        this.guaranteeTypeName = guaranteeTypeName;
    }

    public Integer getFollowStatus() {
        return followStatus;
    }

    public void setFollowStatus(Integer followStatus) {
        this.followStatus = followStatus;
    }

    public BigDecimal getGuaranteeTaxMny() {
        return guaranteeTaxMny;
    }

    public void setGuaranteeTaxMny(BigDecimal guaranteeTaxMny) {
        this.guaranteeTaxMny = guaranteeTaxMny;
    }

    public BigDecimal getGuaranteeMnyPer() {
        return guaranteeMnyPer;
    }

    public void setGuaranteeMnyPer(BigDecimal guaranteeMnyPer) {
        this.guaranteeMnyPer = guaranteeMnyPer;
    }

    public Date getApproveDate() {
        return approveDate;
    }

    public void setApproveDate(Date approveDate) {
        this.approveDate = approveDate;
    }
}
