package com.ejianc.business.gyypoc.vo;

import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;
import java.util.List;

/**
 * 流程主表单据数据载体
 *
 * @author CJ
 * @Description: 流程主表单据数据载体
 * @date 2021/3/23 15:52
 */
public class PurchaseProcessVO extends BaseVO {

    private static final long serialVersionUID = 7216273287573451955L;

    /**
     * 流程阶段状态：填报
     */
    public static final Integer PROCESS_STATE_INIT = 0;

    /**
     * 流程阶段状态：汇总审批
     */
    public static final Integer PROCESS_STATE_APPROVE = 1;

    /**
     * 流程阶段状态：采购
     */
    public static final Integer PROCESS_STATE_PURCHASE = 2;

    /**
     * 流程阶段状态：验收
     */
    public static final Integer PROCESS_STATE_REC = 3;

    /**
     * 流程阶段状态：已结束
     */
    public static final Integer PROCESS_STATE_END = 4;

    /**
     * 主流程编码
     */
    private String billCode;

    /**
     * 主流程名称
     */
    private String name;

    /**
     * 单据状态
     */
    private Integer billState;

    /**
     * 主流程阶段状态：0-填报，1-汇总审批，2-采购，3-验收, 4-已结束
     */
    private Integer processState;

    /**
     * 评审软件需求清单
     */
    List<SoftwareNeedsListVO> softwareNeedsList;

    /**
     * 申请预算
     */
    private BigDecimal applyBudgetAmt;

    /**
     * 验收预算
     */
    private BigDecimal reviewBudgetAmt;

    /**
     * 验收数量
     */
    private Double recNum;

    /**
     * 会议纪要
     */
    private String meetingSummary;

    public String getMeetingSummary() {
        return meetingSummary;
    }

    public void setMeetingSummary(String meetingSummary) {
        this.meetingSummary = meetingSummary;
    }

    public List<SoftwareNeedsListVO> getSoftwareNeedsList() {
        return softwareNeedsList;
    }

    public void setSoftwareNeedsList(List<SoftwareNeedsListVO> softwareNeedsList) {
        this.softwareNeedsList = softwareNeedsList;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getBillState() {
        return billState;
    }

    public BigDecimal getApplyBudgetAmt() {
        return applyBudgetAmt;
    }

    public void setApplyBudgetAmt(BigDecimal applyBudgetAmt) {
        this.applyBudgetAmt = applyBudgetAmt;
    }

    public BigDecimal getReviewBudgetAmt() {
        return reviewBudgetAmt;
    }

    public void setReviewBudgetAmt(BigDecimal reviewBudgetAmt) {
        this.reviewBudgetAmt = reviewBudgetAmt;
    }

    public Double getRecNum() {
        return recNum;
    }

    public void setRecNum(Double recNum) {
        this.recNum = recNum;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public Integer getProcessState() {
        return processState;
    }

    public void setProcessState(Integer processState) {
        this.processState = processState;
    }
}
