package com.ejianc.business.gyypoc.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 软件需求清单
 *
 * @author CJ
 * @Description: 软件需求清单
 * @date 2021/3/23 16:56
 */
public class SoftwareNeedsListVO extends BaseVO {

    private static final long serialVersionUID = 7972990311353340441L;
    /**
     * 所属采购流程Id
     */
    private Long purchaseProcessId;

    /**
     * 对应采购需求单据Id
     */
    private Long purchaseBillId;

    /**
     * 创建人名称
     */
    private String createUserName;

    /**
     * 修改人名称
     */
    private String modifyUserName;

    /**
     * 软件名称
     */
    private String softwareName;

    /**
     * 供应商名称
     */
    private String supplierName;

    /**
     * 软甲版本
     */
    private String softwareVersion;

    /**
     * 软件数量
     */
    private Double softwareNum;

    /**
     * 评审数量
     */
    private Double reviewNum;

    /**
     * 预算（万元）
     */
    private BigDecimal budgetAmt;

    /**
     * 购入类型：0-新购，1-升级
     */
    private String purchaseMode;

    /**
     * 采购时间
     */
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date purchaseDate;

    /**
     * 采购方式
     */
    private String purchaseType;

    /**
     * 主要功能
     */
    private String mainFunction;

    /**
     * 备注
     */
    private String remark;

    /**
     * 申请单位Id
     */
    private Long applyOrgId;

    /**
     * 申请单位名称
     */
    private String applyOrgName;

    /**
     * 验收状态 0 待验收 ，1 已验收
     */
    private Integer recState = 0;

    /**
     * 验收单Id
     */
    private Long recId;

    /**
     * 单据创建人Id
     */
    private Long createUserId;

    /**
     * 审批预算（万元）
     */
    private BigDecimal reviewBudgetAmt;

    /**
     * 采购申请报告编码
     */
    private String purchaseBillCode;

    public String getPurchaseBillCode() {
        return purchaseBillCode;
    }

    public void setPurchaseBillCode(String purchaseBillCode) {
        this.purchaseBillCode = purchaseBillCode;
    }

    public BigDecimal getReviewBudgetAmt() {
        return reviewBudgetAmt;
    }

    public void setReviewBudgetAmt(BigDecimal reviewBudgetAmt) {
        this.reviewBudgetAmt = reviewBudgetAmt;
    }

    public Long getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }

    public Long getApplyOrgId() {
        return applyOrgId;
    }

    public void setApplyOrgId(Long applyOrgId) {
        this.applyOrgId = applyOrgId;
    }

    public String getApplyOrgName() {
        return applyOrgName;
    }

    public void setApplyOrgName(String applyOrgName) {
        this.applyOrgName = applyOrgName;
    }

    public Integer getRecState() {
        return recState;
    }

    public void setRecState(Integer recState) {
        this.recState = recState;
    }

    public Long getPurchaseProcessId() {
        return purchaseProcessId;
    }

    public void setPurchaseProcessId(Long purchaseProcessId) {
        this.purchaseProcessId = purchaseProcessId;
    }

    public Long getPurchaseBillId() {
        return purchaseBillId;
    }

    public void setPurchaseBillId(Long purchaseBillId) {
        this.purchaseBillId = purchaseBillId;
    }

    @Override
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public String getModifyUserName() {
        return modifyUserName;
    }

    public void setModifyUserName(String modifyUserName) {
        this.modifyUserName = modifyUserName;
    }

    public String getSoftwareName() {
        return softwareName;
    }

    public void setSoftwareName(String softwareName) {
        this.softwareName = softwareName;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public String getSoftwareVersion() {
        return softwareVersion;
    }

    public void setSoftwareVersion(String softwareVersion) {
        this.softwareVersion = softwareVersion;
    }

    public Double getSoftwareNum() {
        return softwareNum;
    }

    public void setSoftwareNum(Double softwareNum) {
        this.softwareNum = softwareNum;
    }

    public Double getReviewNum() {
        return reviewNum;
    }

    public void setReviewNum(Double reviewNum) {
        this.reviewNum = reviewNum;
    }

    public BigDecimal getBudgetAmt() {
        return budgetAmt;
    }

    public void setBudgetAmt(BigDecimal budgetAmt) {
        this.budgetAmt = budgetAmt;
    }

    public String getPurchaseMode() {
        return purchaseMode;
    }

    public void setPurchaseMode(String purchaseMode) {
        this.purchaseMode = purchaseMode;
    }

    public Date getPurchaseDate() {
        return purchaseDate;
    }

    public void setPurchaseDate(Date purchaseDate) {
        this.purchaseDate = purchaseDate;
    }

    public String getPurchaseType() {
        return purchaseType;
    }

    public void setPurchaseType(String purchaseType) {
        this.purchaseType = purchaseType;
    }

    public String getMainFunction() {
        return mainFunction;
    }

    public void setMainFunction(String mainFunction) {
        this.mainFunction = mainFunction;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Long getRecId() {
        return recId;
    }

    public void setRecId(Long recId) {
        this.recId = recId;
    }
}
