package com.ejianc.poc.gyy.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.gyypoc.vo.PurchaseProcessVO;
import com.ejianc.business.gyypoc.vo.SoftwareNeedsListVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.poc.gyy.bean.PurchaseProcessEntity;
import com.ejianc.poc.gyy.bean.SoftwareNeedsListEntity;
import com.ejianc.poc.gyy.service.IPurchaseProcessService;
import com.ejianc.poc.gyy.service.ISoftwareNeedsListService;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 流程主表控制器
 *
 * @author CJ
 * @Description: 流程主表控制器
 * @date 2021/3/23 15:52
 */
@RestController
@RequestMapping(value = "/purchaseProcess/")
public class PurchaseProcessController {


    @Autowired
    private IPurchaseProcessService purchaseProcessService;

    @Autowired
    private IBillCodeApi billCodeApi;

    private final static String BILL_CODE= "GYYPOC_PURCHASE_PROCESS";

    @Autowired
    private ISoftwareNeedsListService softwareNeedsListService;

    /**
     * 新生成一个采购流程主单据并将单据提交
     *
     * @param purchaseProcessVO
     * @return
     */
    @PostMapping(value = "startPurchaseProcess")
    public CommonResponse<PurchaseProcessVO> addAndSubmit(@RequestBody PurchaseProcessVO purchaseProcessVO) {
        PurchaseProcessVO vo = null;
        //1、创建新的主流程单据
        CommonResponse<String> codeResp = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
        if(!codeResp.isSuccess()) {
            return CommonResponse.error("保存失败，获取自动编码失败！");
        }
        purchaseProcessVO.setBillCode(codeResp.getData());
        purchaseProcessVO.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        purchaseProcessVO.setProcessState(PurchaseProcessVO.PROCESS_STATE_INIT);

        PurchaseProcessEntity entity = BeanMapper.map(purchaseProcessVO, PurchaseProcessEntity.class);
        purchaseProcessService.saveOrUpdate(entity);

        //2、单据流程提交。
        //TODO

        vo = BeanMapper.map(entity, PurchaseProcessVO.class);
        return CommonResponse.success("流程启动成功！", vo);
    }

    /**
     * 根据采购流程单据审批详情
     *
     * @param id
     * @return
     */
    @GetMapping("queryDetail")
    public CommonResponse<PurchaseProcessVO> queryDetail(@RequestParam(value = "id") Long id) {
        PurchaseProcessVO vo = null;

        PurchaseProcessEntity dbEntity = purchaseProcessService.selectById(id);
        if(null != dbEntity) {
            vo = BeanMapper.map(dbEntity, PurchaseProcessVO.class);

            QueryWrapper<SoftwareNeedsListEntity> softQuery = new QueryWrapper<>();
            softQuery.eq("purchase_process_id", id);
            softQuery.orderByAsc("purchase_bill_id");

            List<SoftwareNeedsListEntity> softList = softwareNeedsListService.list(softQuery);
            if(CollectionUtils.isNotEmpty(softList)) {
                vo.setSoftwareNeedsList(BeanMapper.mapList(softList, SoftwareNeedsListVO.class));
            }
        }
        return CommonResponse.success("查询购流程单据详情成功！", vo);
    }

}
