package com.ejianc.poc.gyy.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.gyypoc.vo.SoftReceiveCheckVO;
import com.ejianc.business.gyypoc.vo.SoftwareNeedsListVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.poc.gyy.bean.SoftwareNeedsListEntity;
import com.ejianc.poc.gyy.service.ISoftwareNeedsListService;
import com.ejianc.support.idworker.util.IdWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.List;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.poc.gyy.bean.SoftReceiveCheckEntity;
import com.ejianc.poc.gyy.service.ISoftReceiveCheckService;

/**
 * 软件验收单
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("softReceiveCheck")
public class SoftReceiveCheckController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    
    @Autowired
    private ISoftReceiveCheckService service; 

    @Autowired
    private ISoftwareNeedsListService needsListService;

    @Autowired
    private IOrgApi orgApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SoftReceiveCheckVO> saveOrUpdate(@RequestBody SoftReceiveCheckVO saveorUpdateVO) {
    	SoftReceiveCheckEntity entity = BeanMapper.map(saveorUpdateVO, SoftReceiveCheckEntity.class);
    	service.saveOrUpdate(entity, false);
    	SoftReceiveCheckVO vo = BeanMapper.map(entity, SoftReceiveCheckVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    
    /**
     * @Description queryDetail 查询详情
     *
     * @param id 此id是软件需求列表单id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SoftReceiveCheckVO> queryDetail(Long id) {
        QueryWrapper<SoftReceiveCheckEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("need_id",id);
    	SoftReceiveCheckEntity entity = service.getOne(wrapper);
    	if(entity==null){
            SoftwareNeedsListEntity needsListEntity = needsListService.selectById(id);
            entity = new SoftReceiveCheckEntity();
            entity.setId(IdWorker.getId());
            entity.setBillState(0);
            entity.setProcessId(needsListEntity.getPurchaseProcessId());
            entity.setNeedId(needsListEntity.getId());
            entity.setName(needsListEntity.getSoftwareName());
            entity.setDeveloperName(needsListEntity.getSupplierName());
            needsListEntity.setRecId(entity.getId());
            entity.setOrgId(needsListEntity.getApplyOrgId());
            needsListService.saveOrUpdate(needsListEntity);
            service.saveOrUpdate(entity);
        }
    	SoftReceiveCheckVO vo = BeanMapper.map(entity, SoftReceiveCheckVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SoftReceiveCheckVO> vos) {
        service.removeByIds(vos.stream().map(SoftReceiveCheckVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SoftReceiveCheckVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        
        IPage<SoftReceiveCheckEntity> page = service.queryPage(param,false);
        IPage<SoftReceiveCheckVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), SoftReceiveCheckVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    @RequestMapping(value = "/queryMobileList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SoftwareNeedsListVO>> queryMobileList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("softwareName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("softwareVersion");
        fuzzyFields.add("mainFunction");
        /** 租户隔离 */
        CommonResponse<List<OrgVO>> response = orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        if(response.isSuccess()){
            param.getParams().put("applyOrgId", new Parameter(QueryParam.IN, response.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<SoftwareNeedsListEntity> page = needsListService.queryPage(param,false);
        IPage<SoftwareNeedsListVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), SoftwareNeedsListVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

}
