package com.ejianc.poc.gyy.service.impl;

import com.ejianc.poc.gyy.bean.PurchaseBillEntity;
import com.ejianc.poc.gyy.mapper.PurchaseBillMapper;
import com.ejianc.poc.gyy.mapper.SoftwareNeedsListMapper;
import com.ejianc.poc.gyy.service.IPurchaseBillService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author CJ
 * @Description:
 * @date 2021/3/23 16:55
 */
@Service(value = "purchaseBillService")
public class PurchaseBillServiceImpl extends BaseServiceImpl<PurchaseBillMapper, PurchaseBillEntity> implements IPurchaseBillService  {

    @Autowired
    private SoftwareNeedsListMapper softwareNeedsListMapper;

    @Override
    public PurchaseBillEntity saveOrUpdatePurchaseBill(PurchaseBillEntity saveEntity) {
        if(CollectionUtils.isNotEmpty(saveEntity.getSoftwareNeedsList())) {
            //更新子表信息
            if(null != saveEntity.getId()) {
                softwareNeedsListMapper.delByPurchaseBillId(saveEntity.getId());
            }
        }
        super.saveOrUpdate(saveEntity, false);
        return saveEntity;
    }

}
