package com.ejianc.poc.gyy.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 软件需求清单实体
 *
 * @author CJ
 * @Description: 软件需求清单实体
 * @date 2021/3/23 16:33
 */
@TableName(value = "ejc_gyypoc_software_needs_list")
public class SoftwareNeedsListEntity extends BaseEntity {

    private static final long serialVersionUID = -2849134034158492232L;
    /**
     * 所属采购流程Id
     */
    @TableField(value = "purchase_process_id")
    private Long purchaseProcessId;

    /**
     * 对应采购需求单据Id
     */
    @TableField(value = "purchase_bill_id")
    private Long purchaseBillId;

    /**
     * 创建人名称
     */
    @TableField(value = "create_user_name")
    private String createUserName;

    /**
     * 修改人名称
     */
    @TableField(value = "modify_user_name")
    private String modifyUserName;

    /**
     * 软件名称
     */
    @TableField(value = "software_name")
    private String softwareName;

    /**
     * 供应商名称
     */
    @TableField(value = "supplier_name")
    private String supplierName;

    /**
     * 软件版本
     */
    @TableField(value = "software_version")
    private String softwareVersion;

    /**
     * 软件数量
     */
    @TableField(value = "software_num")
    private Double softwareNum;

    /**
     * 评审数量
     */
    @TableField(value = "review_num")
    private Double reviewNum;

    /**
     * 预算（万元）
     */
    @TableField(value = "budget_amt")
    private BigDecimal budgetAmt;

    /**
     * 审批预算（万元）
     */
    @TableField(value = "review_budget_amt")
    private BigDecimal reviewBudgetAmt;

    /**
     * 购入类型：0-新购，1-升级
     */
    @TableField(value = "purchase_mode")
    private String purchaseMode;

    /**
     * 采购时间
     */
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    @TableField(value = "purchase_date")
    private Date purchaseDate;

    /**
     * 采购方式
     */
    @TableField(value = "purchase_type")
    private String purchaseType;

    /**
     * 主要功能
     */
    @TableField(value = "main_function")
    private String mainFunction;

    /**
     * 备注
     */
    @TableField(value = "remark")
    private String remark;

    /**
     * 申请单位Id
     */
    @TableField(value = "apply_org_id")
    private Long applyOrgId;

    /**
     * 申请单位名称
     */
    @TableField(value = "apply_org_name")
    private String applyOrgName;

    /**
     * 验收状态 0 待验收 ，1 已验收
     */
    @TableField(value = "rec_state")
    private Integer recState;

    /**
     * 验收单Id
     */
    @TableField(value = "rec_id")
    private Long recId;

    /**
     * 单据创建人Id
     */
    @TableField(value = "create_user_id")
    private Long createUserId;

    public BigDecimal getReviewBudgetAmt() {
        return reviewBudgetAmt;
    }

    public void setReviewBudgetAmt(BigDecimal reviewBudgetAmt) {
        this.reviewBudgetAmt = reviewBudgetAmt;
    }

    public Long getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }

    public Long getApplyOrgId() {
        return applyOrgId;
    }

    public void setApplyOrgId(Long applyOrgId) {
        this.applyOrgId = applyOrgId;
    }

    public String getApplyOrgName() {
        return applyOrgName;
    }

    public void setApplyOrgName(String applyOrgName) {
        this.applyOrgName = applyOrgName;
    }

    public Integer getRecState() {
        return recState;
    }

    public void setRecState(Integer recState) {
        this.recState = recState;
    }

    public Long getPurchaseProcessId() {
        return purchaseProcessId;
    }

    public void setPurchaseProcessId(Long purchaseProcessId) {
        this.purchaseProcessId = purchaseProcessId;
    }

    public Long getPurchaseBillId() {
        return purchaseBillId;
    }

    public void setPurchaseBillId(Long purchaseBillId) {
        this.purchaseBillId = purchaseBillId;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public String getModifyUserName() {
        return modifyUserName;
    }

    public void setModifyUserName(String modifyUserName) {
        this.modifyUserName = modifyUserName;
    }

    public String getSoftwareName() {
        return softwareName;
    }

    public void setSoftwareName(String softwareName) {
        this.softwareName = softwareName;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public String getSoftwareVersion() {
        return softwareVersion;
    }

    public void setSoftwareVersion(String softwareVersion) {
        this.softwareVersion = softwareVersion;
    }

    public Double getSoftwareNum() {
        return softwareNum;
    }

    public void setSoftwareNum(Double softwareNum) {
        this.softwareNum = softwareNum;
    }

    public Double getReviewNum() {
        return reviewNum;
    }

    public void setReviewNum(Double reviewNum) {
        this.reviewNum = reviewNum;
    }

    public BigDecimal getBudgetAmt() {
        return budgetAmt;
    }

    public void setBudgetAmt(BigDecimal budgetAmt) {
        this.budgetAmt = budgetAmt;
    }

    public String getPurchaseMode() {
        return purchaseMode;
    }

    public void setPurchaseMode(String purchaseMode) {
        this.purchaseMode = purchaseMode;
    }

    public Date getPurchaseDate() {
        return purchaseDate;
    }

    public void setPurchaseDate(Date purchaseDate) {
        this.purchaseDate = purchaseDate;
    }

    public String getPurchaseType() {
        return purchaseType;
    }

    public void setPurchaseType(String purchaseType) {
        this.purchaseType = purchaseType;
    }

    public String getMainFunction() {
        return mainFunction;
    }

    public void setMainFunction(String mainFunction) {
        this.mainFunction = mainFunction;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Long getRecId() {
        return recId;
    }

    public void setRecId(Long recId) {
        this.recId = recId;
    }
}
