/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.poc.gyy.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.gyypoc.vo.PurchaseProcessVO;
import com.ejianc.business.gyypoc.vo.SoftwareNeedsListVO;
import com.ejianc.foundation.bpm.api.IBpmApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.poc.gyy.bean.PurchaseProcessEntity;
import com.ejianc.poc.gyy.bean.SoftwareNeedsListEntity;
import com.ejianc.poc.gyy.service.IPurchaseProcessService;
import com.ejianc.poc.gyy.service.ISoftwareNeedsListService;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/purchaseProcess/"})
public class PurchaseProcessController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPurchaseProcessService purchaseProcessService;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "GYYPOC_PURCHASE_PROCESS";
    @Autowired
    private ISoftwareNeedsListService softwareNeedsListService;
    private static final String PC_URL = "ejc-gyypoc-frontend/#/purchaseBill?id={id}";
    private static final String MA_URL = "ejc-gyypoc-mobile/#/apply?id={id}";
    @Autowired
    private IBpmApi bpmApi;
    @Autowired
    private IOrgApi orgApi;
    private static final String BILL_TYPE_CODE = "BT210324000000001";

    @PostMapping(value={"startPurchaseProcess"})
    public CommonResponse<PurchaseProcessVO> addAndSubmit(@RequestBody(required=false) PurchaseProcessVO purchaseProcessVO) {
        CommonResponse codeResp;
        PurchaseProcessVO vo = null;
        if (null == purchaseProcessVO) {
            purchaseProcessVO = new PurchaseProcessVO();
        }
        if (!(codeResp = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid())).isSuccess()) {
            return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u83b7\u53d6\u81ea\u52a8\u7f16\u7801\u5931\u8d25\uff01");
        }
        if (StringUtils.isBlank((CharSequence)purchaseProcessVO.getName())) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
            purchaseProcessVO.setName(sdf.format(new Date()) + " \u5e74\u5ea6\u91c7\u8d2d\u6d41\u7a0b");
        }
        purchaseProcessVO.setBillCode((String)codeResp.getData());
        purchaseProcessVO.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        purchaseProcessVO.setProcessState(PurchaseProcessVO.PROCESS_STATE_INIT);
        PurchaseProcessEntity entity = (PurchaseProcessEntity)((Object)BeanMapper.map((Object)purchaseProcessVO, PurchaseProcessEntity.class));
        this.purchaseProcessService.saveOrUpdate((Object)entity, false);
        Long bpmOrgId = null != purchaseProcessVO.getBpmOrgId() ? purchaseProcessVO.getBpmOrgId() : InvocationInfoProxy.getOrgId();
        HashMap<String, Object> submitParam = new HashMap<String, Object>(20);
        submitParam.put("userId", InvocationInfoProxy.getUserid());
        submitParam.put("billtypeId", BILL_TYPE_CODE);
        submitParam.put("businessKey", entity.getId());
        submitParam.put("assignAble", false);
        submitParam.put("messageType", new String[]{"sys", "weixin"});
        submitParam.put("billOrgId", bpmOrgId);
        submitParam.put("procInstName", entity.getName());
        submitParam.put("formurl", PC_URL);
        submitParam.put("maurl", MA_URL);
        this.logger.info("\u91c7\u8d2d\u6d41\u7a0b\u63d0\u4ea4\u6d41\u7a0b\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString(submitParam));
        CommonResponse submitResp = this.bpmApi.doSubmit(submitParam);
        this.logger.info("\u91c7\u8d2d\u6d41\u7a0b\u63d0\u4ea4\u6d41\u7a0b\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)submitResp));
        if (!submitResp.isSuccess()) {
            this.logger.error("\u91c7\u8d2d\u6d41\u7a0b\u63d0\u4ea4\u5ba1\u6279\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}", (Object)submitResp.getMsg());
            this.purchaseProcessService.removeById(entity.getId());
            return CommonResponse.error((String)"\u6d41\u7a0b\u542f\u52a8\u5931\u8d25\uff01");
        }
        vo = (PurchaseProcessVO)BeanMapper.map((Object)((Object)entity), PurchaseProcessVO.class);
        return CommonResponse.success((String)"\u6d41\u7a0b\u542f\u52a8\u6210\u529f\uff01", (Object)vo);
    }

    @PostMapping(value={"pageList"})
    public CommonResponse<IPage<PurchaseProcessVO>> pageList(@RequestBody QueryParam queryParam) {
        queryParam.getFuzzyFields().add("name");
        queryParam.getOrderMap().put("createTime", "desc");
        IPage pageData = this.purchaseProcessService.queryPage(queryParam);
        Page resp = new Page();
        resp.setSize(pageData.getSize());
        resp.setRecords(BeanMapper.mapList((Iterable)pageData.getRecords(), PurchaseProcessVO.class));
        resp.setCurrent(pageData.getCurrent());
        resp.setTotal(pageData.getTotal());
        resp.setPages(pageData.getPages());
        return CommonResponse.success((String)"\u5206\u9875\u67e5\u8be2\u91c7\u8d2d\u6d41\u7a0b\u5217\u8868\u6210\u529f", (Object)resp);
    }

    @GetMapping(value={"queryDetail"})
    public CommonResponse<PurchaseProcessVO> queryDetail(@RequestParam(value="id") Long id) {
        PurchaseProcessVO vo = null;
        PurchaseProcessEntity dbEntity = (PurchaseProcessEntity)((Object)this.purchaseProcessService.selectById(id));
        if (null != dbEntity) {
            vo = (PurchaseProcessVO)BeanMapper.map((Object)((Object)dbEntity), PurchaseProcessVO.class);
            QueryWrapper softQuery = new QueryWrapper();
            softQuery.eq((Object)"purchase_process_id", (Object)id);
            softQuery.orderByAsc((Object)"purchase_bill_id");
            softQuery.in((Object)"apply_org_id", this.getPageQueryParam(null));
            List softList = this.softwareNeedsListService.list((Wrapper)softQuery);
            ArrayList<Object> softVos = new ArrayList<Object>();
            if (CollectionUtils.isNotEmpty((Collection)softList)) {
                BigDecimal zero;
                BigDecimal applyBudgetAmt = zero = BigDecimal.ZERO.setScale(8);
                BigDecimal reviewBudgetAmt = zero;
                for (SoftwareNeedsListEntity soft : softList) {
                    reviewBudgetAmt = reviewBudgetAmt.add(null != soft.getReviewBudgetAmt() ? soft.getReviewBudgetAmt() : zero);
                    applyBudgetAmt = applyBudgetAmt.add(null != soft.getBudgetAmt() ? soft.getBudgetAmt() : zero);
                    softVos.add(BeanMapper.map((Object)((Object)soft), SoftwareNeedsListVO.class));
                }
                vo.setReviewBudgetAmt(reviewBudgetAmt);
                vo.setApplyBudgetAmt(applyBudgetAmt);
                vo.setSoftwareNeedsList(BeanMapper.mapList((Iterable)softList, SoftwareNeedsListVO.class));
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8d2d\u6d41\u7a0b\u5355\u636e\u8be6\u60c5\u6210\u529f\uff01", vo);
    }

    public List<Long> getPageQueryParam(Long orgId) {
        if (null == orgId) {
            orgId = InvocationInfoProxy.getOrgId();
        }
        CommonResponse childOrgResp = this.orgApi.findChildrenByParentId(orgId);
        ArrayList<Long> childIds = new ArrayList<Long>();
        childIds.addAll(((List)childOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        return childIds;
    }

    @GetMapping(value={"queryReceiveDetail"})
    public CommonResponse<PurchaseProcessVO> queryReceiveDetail(@RequestParam(value="id") Long id) {
        PurchaseProcessVO vo = null;
        PurchaseProcessEntity dbEntity = (PurchaseProcessEntity)((Object)this.purchaseProcessService.selectById(id));
        if (null != dbEntity) {
            vo = (PurchaseProcessVO)BeanMapper.map((Object)((Object)dbEntity), PurchaseProcessVO.class);
            QueryWrapper softQuery = new QueryWrapper();
            softQuery.eq((Object)"purchase_process_id", (Object)id);
            CommonResponse response = this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
            softQuery.orderByAsc((Object)"purchase_bill_id");
            softQuery.in((Object)"apply_org_id", (Collection)((List)response.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
            ArrayList<Object> softVos = new ArrayList<Object>();
            List softList = this.softwareNeedsListService.list((Wrapper)softQuery);
            if (CollectionUtils.isNotEmpty((Collection)softList)) {
                BigDecimal zero;
                BigDecimal reviewBudgetAmt = zero = BigDecimal.ZERO.setScale(8);
                BigDecimal applyBudgetAmt = zero;
                for (SoftwareNeedsListEntity soft : softList) {
                    reviewBudgetAmt = reviewBudgetAmt.add(null != soft.getReviewBudgetAmt() ? soft.getReviewBudgetAmt() : zero);
                    applyBudgetAmt = applyBudgetAmt.add(null != soft.getBudgetAmt() ? soft.getBudgetAmt() : zero);
                    softVos.add(BeanMapper.map((Object)((Object)soft), SoftwareNeedsListVO.class));
                }
                vo.setReviewBudgetAmt(reviewBudgetAmt);
                vo.setApplyBudgetAmt(applyBudgetAmt);
                vo.setSoftwareNeedsList(BeanMapper.mapList((Iterable)softList, SoftwareNeedsListVO.class));
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8d2d\u6d41\u7a0b\u5355\u636e\u8be6\u60c5\u6210\u529f\uff01", vo);
    }

    @PostMapping(value={"saveOrUpdate"})
    public CommonResponse<PurchaseProcessVO> saveOrUpdate(@RequestBody PurchaseProcessVO purchaseProcessVO) {
        PurchaseProcessEntity dbEntity = (PurchaseProcessEntity)((Object)this.purchaseProcessService.selectById(purchaseProcessVO.getId()));
        BigDecimal reviewBudgetAmt = BigDecimal.ZERO.setScale(8);
        BigDecimal applyBudgetAmt = BigDecimal.ZERO.setScale(8);
        ArrayList<SoftwareNeedsListEntity> saveList = new ArrayList<SoftwareNeedsListEntity>();
        if (CollectionUtils.isNotEmpty((Collection)purchaseProcessVO.getSoftwareNeedsList())) {
            for (SoftwareNeedsListVO soft : purchaseProcessVO.getSoftwareNeedsList()) {
                reviewBudgetAmt = reviewBudgetAmt.add(soft.getReviewBudgetAmt());
                applyBudgetAmt = applyBudgetAmt.add(soft.getBudgetAmt());
                saveList.add((SoftwareNeedsListEntity)((Object)BeanMapper.map((Object)soft, SoftwareNeedsListEntity.class)));
            }
            dbEntity.setReviewBudgetAmt(reviewBudgetAmt);
            dbEntity.setApplyBudgetAmt(applyBudgetAmt);
        }
        dbEntity.setMeetingSummary(purchaseProcessVO.getMeetingSummary());
        purchaseProcessVO = this.purchaseProcessService.savePurChaseProcess(dbEntity, saveList);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01", (Object)purchaseProcessVO);
    }
}

