/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.poc.gyy.service.impl;

import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.poc.gyy.bean.PurchaseBillEntity;
import com.ejianc.poc.gyy.service.IPurchaseBillService;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="purchaseBill")
public class PurchaseBillBpmCallbackServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPurchaseBillService purchaseBillService;
    @Autowired
    private SessionManager sessionManager;

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u91c7\u8d2d\u7533\u8bf7\u62a5\u544a\u63d0\u4ea4\u5ba1\u6279\u56de\u8c03--billId:{}, state: {}", (Object)billId, (Object)state);
        PurchaseBillEntity entity = (PurchaseBillEntity)((Object)this.purchaseBillService.selectById(billId));
        UserContext userContext = this.sessionManager.getUserContext();
        entity.setCommitDate(new Date());
        entity.setCommitUserCode(userContext.getUserCode());
        entity.setCommitUserName(userContext.getUserName());
        this.purchaseBillService.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u91c7\u8d2d\u7533\u8bf7\u62a5\u544a\u63d0\u4ea4\u5ba1\u6279\u56de\u8c03\u6210\u529f\uff01");
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u91c7\u8d2d\u7533\u8bf7\u62a5\u544a\u6279\u5b8c\u6210\u56de\u8c03--billId:{}, state: {}", (Object)billId, (Object)state);
        PurchaseBillEntity entity = (PurchaseBillEntity)((Object)this.purchaseBillService.selectById(billId));
        if (BillStateEnum.COMMITED_STATE.getBillStateCode().equals(state)) {
            UserContext userContext = this.sessionManager.getUserContext();
            entity.setCommitDate(new Date());
            entity.setCommitUserCode(userContext.getUserCode());
            entity.setCommitUserName(userContext.getUserName());
            this.purchaseBillService.saveOrUpdate((Object)entity, false);
        }
        return CommonResponse.success((String)"\u91c7\u8d2d\u7533\u8bf7\u62a5\u544a\u6279\u5b8c\u6210\u56de\u8c03\u6210\u529f\uff01");
    }
}

