package com.ejianc.business.house.controller;

import java.io.Serializable;

import com.ejianc.business.house.bean.FwzlhtEntity;
import com.ejianc.business.house.service.IFwzlhtService;
import com.ejianc.business.house.vo.FwzlhtVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.house.bean.FwzlhtzzEntity;
import com.ejianc.business.house.service.IFwzlhtzzService;
import com.ejianc.business.house.vo.FwzlhtzzVO;

/**
 * 房屋租赁合同终止
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("fwzlhtzz")
public class FwzlhtzzController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "FWZLHTZZ_CODE";//此处需要根据实际修改

    @Autowired
    private IFwzlhtzzService service;

    @Autowired
    private IFwzlhtService iFwzlhtServiceservice;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<FwzlhtzzVO> saveOrUpdate(@RequestBody FwzlhtzzVO saveOrUpdateVO) {
    	FwzlhtzzEntity entity = BeanMapper.map(saveOrUpdateVO, FwzlhtzzEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
             //   entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                entity.setHtzt(1);  //终止保存时，将合同状态更新为终止，同时将租赁合同里的状态也更新
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);

    	FwzlhtzzVO vo = BeanMapper.map(entity, FwzlhtzzVO.class);
    	//将租赁合同里的合同状态更新为终止
        FwzlhtEntity fwzlhtEntity = new FwzlhtEntity();
        fwzlhtEntity.setId(entity.getFwzlhtId());
        fwzlhtEntity.setBillCode(entity.getFwzlhtCode());
        fwzlhtEntity.setBdcbhName(entity.getBhcbh());  //不动产编号
        fwzlhtEntity.setFclx(entity.getFclx());  //房产类型
        fwzlhtEntity.setBhczh(entity.getBhczh());  //不动产证号
        fwzlhtEntity.setFwzl(entity.getFwzl());  //房屋坐落
        fwzlhtEntity.setFh(entity.getFh());  //房号
        fwzlhtEntity.setCzmj(entity.getCzmj());  //承租面积
        fwzlhtEntity.setZjbz(entity.getZjbz());  //租金标准
        fwzlhtEntity.setJnfs(entity.getJnfs());  //交纳方式
        fwzlhtEntity.setQdrq(entity.getQdrq());  //签订日期
        fwzlhtEntity.setZlksrq(entity.getZlksrq());     //租赁开始日期
        fwzlhtEntity.setZljsrq(entity.getZljsrq());  //租赁结束日期
        fwzlhtEntity.setCzdw(entity.getCzdw());  //承租单位
        fwzlhtEntity.setZjlx(entity.getZjlx());  //证件类型
        fwzlhtEntity.setZjh(entity.getZjh());  //证件号
        fwzlhtEntity.setLxrName(entity.getLxr());  //联系人
        fwzlhtEntity.setLxdz(entity.getLxdz());  //联系地址
        fwzlhtEntity.setSjh(entity.getSjh());  //手机号
        fwzlhtEntity.setHtzt(1);  //合同状态
        fwzlhtEntity.setOrgId(entity.getOrgId());
        fwzlhtEntity.setOrgName(entity.getOrgName());
        iFwzlhtServiceservice.updateById(fwzlhtEntity);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<FwzlhtzzVO> queryDetail(Long id) {
    	FwzlhtzzEntity entity = service.selectById(id);
    	FwzlhtzzVO vo = BeanMapper.map(entity, FwzlhtzzVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<FwzlhtzzVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (FwzlhtzzVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(FwzlhtzzVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<FwzlhtzzVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<FwzlhtzzEntity> page = service.queryPage(param,false);
        IPage<FwzlhtzzVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), FwzlhtzzVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<FwzlhtzzEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Fwzlhtzz-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refFwzlhtzzData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<FwzlhtzzVO>> refFwzlhtzzData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<FwzlhtzzEntity> page = service.queryPage(param,false);
        IPage<FwzlhtzzVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), FwzlhtzzVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
