package com.ejianc.business.house.service.impl;

import com.ejianc.business.house.bean.FwzlhtEntity;
import com.ejianc.business.sealm.api.IInstoreApi;
import com.ejianc.business.sealm.vo.YysqVO;
import com.ejianc.framework.core.exception.BusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

@Service("fwzlht") 
public class FwzlhtBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private	FwzlhtServiceImpl fwzlhtService;

	@Autowired
	private IInstoreApi iInstoreApi;

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		FwzlhtEntity entity = fwzlhtService.getById(billId);
		//审批通过对项目用印申请新增一条数据
		YysqVO yysqVO = new YysqVO();
		yysqVO.setBidId(billId);  //房屋租赁合同id
		yysqVO.setOrgId(entity.getOrgId());  //组织id
		yysqVO.setOrgName(entity.getOrgName());  //组织名称
		yysqVO.setBidCode(entity.getBillCode());  //投标报名编码
		yysqVO.setYysxId("fwzlht/card");//用印事项，存投标报名的访问路径
		yysqVO.setYysxName("房屋管理-房租租赁合同");
		yysqVO.setYyReason("房屋管理-房租租赁合同-" + entity.getBillCode());  //用印事由
		yysqVO.setSqdwId(entity.getOrgId());  //申请单位id
		yysqVO.setSqdwName(entity.getOrgName());  //申请单位name
		yysqVO.setSqrId(entity.getLxrId());  //负责人id
		yysqVO.setSqrName(entity.getLxrName());  //负责人name
		yysqVO.setCreateUserCode(entity.getCreateUserCode());  //创建人
		//审批通过的都是集团公章,所以，印章类别是实体章，印章级别是集团，用印类型是集团公章
		//因为设计时，印章类别，印章级别，用印类型都是自定义档案，所以ID很长
		Long yzlbId = 1472851128843505665L;
		yysqVO.setYzlbId(yzlbId);
		yysqVO.setYzlbName("实体印章");
		Long yzjbId = 1472858324830523394L;
		yysqVO.setYzjbId(yzjbId);
		yysqVO.setYzjbName("集团");
		Long yylxId = 1472859069613084673L;
		yysqVO.setYylxId(yylxId);
		yysqVO.setYylxName("集团公章");
		yysqVO.setMessageFrom(4);// 数据来源：0自建，1投标报名，2资格评审，3投标文件评审,4房屋租赁合同
		CommonResponse<String> yysqBack = iInstoreApi.addYysq(yysqVO);
		if(!yysqBack.isSuccess()){
			throw new BusinessException("新增项目用印申请表数据失败，原因：xxxx" + yysqBack);
		}
		logger.info("发送房屋租赁合同数据：{终审审核完回调}");
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
