package com.ejianc.business.hr.vo;


import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author: jiang
 * @Date: 2024/6/14 11:55
 *
 *  薪资发放明细
 **/
public class SalaryDetailVO extends UserDataVO {
    private Date serviceDate;//发放日期
    private Integer serviceNum;//发放次数
    private String salaryOrgName;//薪资明细中所属组织
    private String acSet;//账套名称
    private BigDecimal baseMny;//导入基础工资
    private BigDecimal postMny;//导入岗位工资
    private BigDecimal trafficMny;//导入交通补贴
    private BigDecimal titleMny;//导入职称津贴
    private BigDecimal workOverTimeMny;//导入加班费
    private BigDecimal festivalMny1;//导入过节费1
    private BigDecimal festivalMny2;//导入过节费2
    private BigDecimal taxMnyRemark1;//应发计税项备用1
    private BigDecimal taxMnyRemark2;//应发计税项备用2
    private BigDecimal deductionMny;//导入各项扣款
    private BigDecimal mealMny;//应发免税餐补
    private BigDecimal oneChildMny;//应发免税独生子女费
    private BigDecimal mnyRemark1;//应发免税备用1
    private BigDecimal mnyRemark2;//应发免税备用2
    private BigDecimal oldMny;//导入个人养老
    private BigDecimal medicineMny;//导入个人医疗
    private BigDecimal unemploymentMny;//导入个人失业
    private BigDecimal bigMedicineMny;//导入大病保险
    private BigDecimal fundMny;//导入住房公积金
    private BigDecimal shouldSalaryMny;//导入应发工资
    private BigDecimal actualSalaryMny;//导入实发会计
    private BigDecimal totalFiveDeductionMny;//导入累计五项专项扣除
    private BigDecimal taxMny; //导入本月缴纳个税
    private String sequence;//导入记录序号
    private String salaryState;//导入工资状态
    private String financeCode;//财务唯一指标

    /**
     * 社保：
     *
     * 个人社保=导入基本养老保险个人缴费+导入失业保险个人缴费+导入基本医疗保险个人缴费+大病保险
     *
     * 单位社保=导入基本养老保险单位缴费+导入失业保险单位缴费+导入基本医疗保险单位缴费+导入工伤保险单位缴费+导入生育保险单位缴费
     */
    private BigDecimal totalPersonSocialMny;//个人社保
    private BigDecimal totalOrgSocialMny;//单位社保


    /**
     * 公积金：
     *      单位公积金=个人缴费（单位缴费暂无数据，取个人缴费即可）
     */
    private BigDecimal totalPersonFundMny;//个人公积金
    private BigDecimal totalOrgFundMny;//单位公积金

    /**
     * 单位承担人工成本 = 导入应发工资+单位社保
     *      （单位缴费+导入基本养老保险单位缴费+导入失业保险单位缴费+导入基本医疗保险单位缴费+导入工伤保险单位缴费+导入生育保险单位缴费）
     */
    private BigDecimal totalOrgCostMny;//单位承担人工成本

    public Date getServiceDate() {
        return serviceDate;
    }

    public void setServiceDate(Date serviceDate) {
        this.serviceDate = serviceDate;
    }

    public Integer getServiceNum() {
        return serviceNum;
    }

    public void setServiceNum(Integer serviceNum) {
        this.serviceNum = serviceNum;
    }

    public String getSalaryOrgName() {
        return salaryOrgName;
    }

    public void setSalaryOrgName(String salaryOrgName) {
        this.salaryOrgName = salaryOrgName;
    }

    public String getAcSet() {
        return acSet;
    }

    public void setAcSet(String acSet) {
        this.acSet = acSet;
    }

    public BigDecimal getBaseMny() {
        return baseMny;
    }

    public void setBaseMny(BigDecimal baseMny) {
        this.baseMny = baseMny;
    }

    public BigDecimal getPostMny() {
        return postMny;
    }

    public void setPostMny(BigDecimal postMny) {
        this.postMny = postMny;
    }

    public BigDecimal getTrafficMny() {
        return trafficMny;
    }

    public void setTrafficMny(BigDecimal trafficMny) {
        this.trafficMny = trafficMny;
    }

    public BigDecimal getTitleMny() {
        return titleMny;
    }

    public void setTitleMny(BigDecimal titleMny) {
        this.titleMny = titleMny;
    }

    public BigDecimal getWorkOverTimeMny() {
        return workOverTimeMny;
    }

    public void setWorkOverTimeMny(BigDecimal workOverTimeMny) {
        this.workOverTimeMny = workOverTimeMny;
    }

    public BigDecimal getFestivalMny1() {
        return festivalMny1;
    }

    public void setFestivalMny1(BigDecimal festivalMny1) {
        this.festivalMny1 = festivalMny1;
    }

    public BigDecimal getFestivalMny2() {
        return festivalMny2;
    }

    public void setFestivalMny2(BigDecimal festivalMny2) {
        this.festivalMny2 = festivalMny2;
    }

    public BigDecimal getTaxMnyRemark1() {
        return taxMnyRemark1;
    }

    public void setTaxMnyRemark1(BigDecimal taxMnyRemark1) {
        this.taxMnyRemark1 = taxMnyRemark1;
    }

    public BigDecimal getTaxMnyRemark2() {
        return taxMnyRemark2;
    }

    public void setTaxMnyRemark2(BigDecimal taxMnyRemark2) {
        this.taxMnyRemark2 = taxMnyRemark2;
    }

    public BigDecimal getDeductionMny() {
        return deductionMny;
    }

    public void setDeductionMny(BigDecimal deductionMny) {
        this.deductionMny = deductionMny;
    }

    public BigDecimal getMealMny() {
        return mealMny;
    }

    public void setMealMny(BigDecimal mealMny) {
        this.mealMny = mealMny;
    }

    public BigDecimal getOneChildMny() {
        return oneChildMny;
    }

    public void setOneChildMny(BigDecimal oneChildMny) {
        this.oneChildMny = oneChildMny;
    }

    public BigDecimal getMnyRemark1() {
        return mnyRemark1;
    }

    public void setMnyRemark1(BigDecimal mnyRemark1) {
        this.mnyRemark1 = mnyRemark1;
    }

    public BigDecimal getMnyRemark2() {
        return mnyRemark2;
    }

    public void setMnyRemark2(BigDecimal mnyRemark2) {
        this.mnyRemark2 = mnyRemark2;
    }

    public BigDecimal getOldMny() {
        return oldMny;
    }

    public void setOldMny(BigDecimal oldMny) {
        this.oldMny = oldMny;
    }

    public BigDecimal getMedicineMny() {
        return medicineMny;
    }

    public void setMedicineMny(BigDecimal medicineMny) {
        this.medicineMny = medicineMny;
    }

    public BigDecimal getUnemploymentMny() {
        return unemploymentMny;
    }

    public void setUnemploymentMny(BigDecimal unemploymentMny) {
        this.unemploymentMny = unemploymentMny;
    }

    public BigDecimal getBigMedicineMny() {
        return bigMedicineMny;
    }

    public void setBigMedicineMny(BigDecimal bigMedicineMny) {
        this.bigMedicineMny = bigMedicineMny;
    }

    public BigDecimal getFundMny() {
        return fundMny;
    }

    public void setFundMny(BigDecimal fundMny) {
        this.fundMny = fundMny;
    }

    public BigDecimal getShouldSalaryMny() {
        return shouldSalaryMny;
    }

    public void setShouldSalaryMny(BigDecimal shouldSalaryMny) {
        this.shouldSalaryMny = shouldSalaryMny;
    }

    public BigDecimal getActualSalaryMny() {
        return actualSalaryMny;
    }

    public void setActualSalaryMny(BigDecimal actualSalaryMny) {
        this.actualSalaryMny = actualSalaryMny;
    }

    public BigDecimal getTotalFiveDeductionMny() {
        return totalFiveDeductionMny;
    }

    public void setTotalFiveDeductionMny(BigDecimal totalFiveDeductionMny) {
        this.totalFiveDeductionMny = totalFiveDeductionMny;
    }

    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }

    public String getSequence() {
        return sequence;
    }

    public void setSequence(String sequence) {
        this.sequence = sequence;
    }

    public String getSalaryState() {
        return salaryState;
    }

    public void setSalaryState(String salaryState) {
        this.salaryState = salaryState;
    }

    public String getFinanceCode() {
        return financeCode;
    }

    public void setFinanceCode(String financeCode) {
        this.financeCode = financeCode;
    }

    public BigDecimal getTotalPersonSocialMny() {
        return totalPersonSocialMny;
    }

    public void setTotalPersonSocialMny(BigDecimal totalPersonSocialMny) {
        this.totalPersonSocialMny = totalPersonSocialMny;
    }

    public BigDecimal getTotalOrgSocialMny() {
        return totalOrgSocialMny;
    }

    public void setTotalOrgSocialMny(BigDecimal totalOrgSocialMny) {
        this.totalOrgSocialMny = totalOrgSocialMny;
    }

    public BigDecimal getTotalPersonFundMny() {
        return totalPersonFundMny;
    }

    public void setTotalPersonFundMny(BigDecimal totalPersonFundMny) {
        this.totalPersonFundMny = totalPersonFundMny;
    }

    public BigDecimal getTotalOrgFundMny() {
        return totalOrgFundMny;
    }

    public void setTotalOrgFundMny(BigDecimal totalOrgFundMny) {
        this.totalOrgFundMny = totalOrgFundMny;
    }

    public BigDecimal getTotalOrgCostMny() {
        return totalOrgCostMny;
    }

    public void setTotalOrgCostMny(BigDecimal totalOrgCostMny) {
        this.totalOrgCostMny = totalOrgCostMny;
    }
}
