package com.ejianc.business.hr.api;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.hr.hystrix.BaseUserHystrix;
import com.ejianc.business.hr.vo.ResidencyUserVO;
import com.ejianc.business.hr.vo.UserDataVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @Author: jiang
 * @Date: 2024/7/3 16:02
 * 用户基本信息，包含子表信息查询
 **/
@FeignClient(name = "ejc-hrmanage-web", url = "${common.env.feign-client-url}", path = "ejc-hrmanage-web", fallback = BaseUserHystrix
        .class)

public interface IBaseUserApi {
    /**
     * 查询所有派驻人员
     */
    @PostMapping(value = "/residencyUser/queryResidencyUser")
    CommonResponse<IPage<ResidencyUserVO>> queryResidencyUser(@RequestBody QueryParam param);


    @PostMapping(value = "/baseUser/api/queryAllUserData")
    CommonResponse<List<UserDataVO>> queryAllUserDataApi(@RequestBody QueryParam param);
}
