package com.ejianc.business.hr.api;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.hr.hystrix.BaseUserHystrix;
import com.ejianc.business.hr.vo.ResidencyUserVO;
import com.ejianc.business.hr.vo.hrm.UserJobVO;
import com.ejianc.business.hr.vo.salarySystem.SalaryAttendanceDataVO;
import com.ejianc.business.hr.vo.salarySystem.SalaryJobDataVO;
import com.ejianc.business.hr.vo.salarySystem.SalaryTransferDataVO;
import com.ejianc.business.hr.vo.salarySystem.SalaryUserDataVO;
import com.ejianc.business.hr.vo.UserDataVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @Author: jiang
 * @Date: 2024/7/3 16:02
 * 用户基本信息，包含子表信息查询
 **/
@FeignClient(name = "ejc-hrmanage-web", url = "${common.env.feign-client-url}", path = "ejc-hrmanage-web", fallback = BaseUserHystrix
        .class)

public interface IBaseUserApi {
    /**
     * 查询所有派驻人员
     */
    @PostMapping(value = "/residencyUser/queryResidencyUser")
    CommonResponse<IPage<ResidencyUserVO>> queryResidencyUser(@RequestBody QueryParam param);


    @PostMapping(value = "/baseUser/api/queryAllUserData")
    CommonResponse<List<UserDataVO>> queryAllUserDataApi(@RequestBody QueryParam param);

    /**
     * 薪资系统-人员信息
     * @param param
     * @return
     */
    @PostMapping(value = "/baseUser/api/queryAllUserSalary")
    CommonResponse<List<SalaryUserDataVO>> queryAllUserSalary(@RequestBody QueryParam param);

    /**
     * 薪资系统-兼职信息
     * @param param
     * @return
     */
    @PostMapping(value = "/baseUser/api/queryAllJobSalary")
    CommonResponse<List<SalaryJobDataVO>> queryAllJobSalary(@RequestBody QueryParam param);

    /**
     * 薪资系统-考勤信息
     * @param param
     * @return
     */
    @PostMapping(value = "/baseUser/api/queryAllAttendanceSalary")
    CommonResponse<List<SalaryAttendanceDataVO>> queryAllAttendanceSalary(@RequestBody QueryParam param);

    /**
     * 薪资系统-异动信息
     * @param param
     * @return
     */
    @PostMapping(value = "/baseUser/api/queryAllTransferSalary")
    CommonResponse<List<SalaryTransferDataVO>> queryAllTransferSalary(@RequestBody QueryParam param);

    @GetMapping(value = "/refPartTimeUserList")
    CommonResponse<List<UserJobVO>> refPartTimeUserList(String userCode,String jobState);
}
