package com.ejianc.business.hr.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.hr.service.IBaseUserService;
import com.ejianc.business.hr.utils.Base64Method;
import com.ejianc.business.hr.vo.*;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 人力工资信息
 *
 * @author generator
 */
@Controller
@RequestMapping("userMny")
public class UserMnyController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IBaseUserService service;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IUserApi userApi;

    public static List<Long> ignoreOrgIds = Arrays.asList(
            1502571153791651841L,
            1502571153867149313L,
            1502571153946841090L,
            1502571154018144258L,
            1502571154072670209L,
            1502571154123001857L,
            1502571154173333505L,
            1502571154223665153L,
            1502571154273996802L,
            1502571154383048706L,
            1502571154433380353L,
            1502571154655678465L,
            1502571154714398722L,
            1502571154785701889L,
            1502571154831839233L,
            1502571154890559490L,
            1502571155016388610L,
            1502571155255463937L,
            1502571156329205762L,
            1502571158292140033L,
            1502571158329888770L,
            1502571158547992578L,
            1502571158589935618L,
            1502571158661238786L,
            1633860192344920066L,
            1687493596574613506L,
            1777728175354720258L
            );

//    /**
//     * @param param
//     * @Description queryUserMnyData 查询人员欠薪列表
//     */
//    @RequestMapping(value = "/queryUserMnyData", method = RequestMethod.POST)
//    @ResponseBody
//    public CommonResponse<IPage<UserDataVO>> queryUserMnyData(@RequestBody QueryParam param) {
//
//        /** 模糊搜索配置字段示例 */
//        List<String> fuzzyFields = param.getFuzzyFields();
//        fuzzyFields.add("h.A0101");
//        fuzzyFields.add("a.A0100");
//        fuzzyFields.add("a.dw");
//        fuzzyFields.add("a.gw");
//        fuzzyFields.add("c.codeitemdesc");
//        /**
//         * 组织隔离
//         */
//        //普通组织 id
////        List<OrgVO> orgVOList = null;
////        List<String> orgCodes = new ArrayList<>();
////        if(!param.getParams().containsKey("orgId")) {
////            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
////        } else {
////            Long orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
////            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
////        }
////        orgVOList.stream().forEach(org -> {
////            //普通组织
////            orgCodes.add(org.getCode());
////        });
////        if (CollectionUtils.isNotEmpty(orgCodes)) {
////            /** 要求主表有orgId字段，保存单据所属组织 */
////            param.getParams().put("orgCode", new Parameter(QueryParam.IN, orgCodes));
////            param.getParams().remove("orgId");
////        }
//        /**
//         *实现分页
//         */
//        Page<ResidencyUserDataVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
//        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);
//
//        page.setRecords(service.queryUserChangeData(page, wrapper));
//
//        return CommonResponse.success("查询列表数据成功！", page);
//
//    }

    /**
     * @param param
     * @Description queryUserMnyDetail 查询人员欠薪明细
     */
    @RequestMapping(value = "/queryUserMnyDetail", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<UserMnyDetailVO>> queryUserMnyDetail(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("department_name");
        fuzzyFields.add("org_name");
        param.getOrderMap().put("orgSequence", "asc");
        param.getOrderMap().put("departmentSequence", "asc");
        param.getOrderMap().put("employeeSequence", "asc");
        /**
         * 组织隔离
         */
        boolean orgTypeFlag = false;
        //普通组织 id
        List<OrgVO> orgVOList = new ArrayList<>();
        List<String> orgCodes = new ArrayList<>();
        if(param.getParams().get("orgCode") == null){
            if (param.getParams().containsKey("orgId") && param.getParams().get("orgId").getValue() != null) {
                Long orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
                String orgType = "";
                if(param.getParams().get("orgType") != null){
                    orgType =param.getParams().get("orgType").getValue().toString();

                }if (!"5".equals(orgType)){//不是项目
                    orgTypeFlag = true;
                }
            } else {
                String orgType = InvocationInfoProxy.getOrgType();
                if (!"5".equals(orgType)){//不是项目
                    orgTypeFlag = true;
                }
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
            }
            orgVOList.stream().forEach(org -> {
                //普通组织
                orgCodes.add(org.getCode());
            });
            if (CollectionUtils.isNotEmpty(orgCodes)) {
                /** 要求主表有orgId字段，保存单据所属组织 */
                if(orgTypeFlag) {
                    param.getParams().put("orgCode", new Parameter(QueryParam.IN, orgCodes));
                }else {
                    param.getParams().put("departmentCode", new Parameter(QueryParam.IN, orgCodes));
                }
                param.getParams().remove("orgId");
                param.getParams().remove("orgType");
            }
        }
        /**
         *实现分页
         */
        Page<UserMnyDetailVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);

        page.setRecords(service.queryUserMnyDetail(page, wrapper));

        return CommonResponse.success("查询列表数据成功！", page);

    }

    /**
     * @param param
     * @Description queryUserMnyDetail 查询个人欠薪统计
     */
    @RequestMapping(value = "/queryUserMnyData", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<UserMnyDetailVO>> queryUserMnyData(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("department_name");
        fuzzyFields.add("org_name");
        param.getOrderMap().put("orgSequence", "asc");
        param.getOrderMap().put("departmentSequence", "asc");
        param.getOrderMap().put("employeeSequence", "asc");
        /**
         * 组织隔离
         */
        boolean orgTypeFlag = false;
        //普通组织 id
        List<OrgVO> orgVOList = new ArrayList<>();
        List<String> orgCodes = new ArrayList<>();
        if(param.getParams().get("orgCode") == null){
            if (param.getParams().containsKey("orgId") && param.getParams().get("orgId").getValue() != null) {
                Long orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
                String orgType = "";
                if(param.getParams().get("orgType") != null){
                    orgType =param.getParams().get("orgType").getValue().toString();

                }if (!"5".equals(orgType)){//不是项目
                    orgTypeFlag = true;
                }
            } else {
                String orgType = InvocationInfoProxy.getOrgType();
                if (!"5".equals(orgType)){//不是项目
                    orgTypeFlag = true;
                }
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
            }
            orgVOList.stream().forEach(org -> {
                //普通组织
                orgCodes.add(org.getCode());
            });
            if (CollectionUtils.isNotEmpty(orgCodes)) {
                /** 要求主表有orgId字段，保存单据所属组织 */
                if(orgTypeFlag) {
                    param.getParams().put("orgCode", new Parameter(QueryParam.IN, orgCodes));
                }else {
                    param.getParams().put("departmentCode", new Parameter(QueryParam.IN, orgCodes));
                }
                param.getParams().remove("orgId");
                param.getParams().remove("orgType");
            }
        }

        /**
         *实现分页
         */
        Page<UserMnyDetailVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);
        List<UserMnyDetailVO> vos = service.queryUserMnyData(page, wrapper);
        /**
         * url etoken生成并放入VO返回
         */
        for (UserMnyDetailVO reportVO : vos) {
            //通过建造师编号查询员工信息
            CommonResponse<UserVO> userVO = userApi.queryUserByUserCode(reportVO.getUserCode());
            if (userVO != null) {
                try {
                    UserVO userVOData = userVO.getData();
                    if (userVOData != null) {
                        String userCode = userVOData.getUserCode();
                        //登录账号+,999912310000
                        userCode = userCode + ",999912310000";
                        //BASE64 GBK编码在URL GBK编码
                        String etoken = URLEncoder.encode(Base64Method.EncryptBase64(userCode), "GBK");
                        String url = "http://hr.zzyjjt.com/templates/index/ssoiframe.jsp?url=/workbench/browse/showselfinfo.do?b_search=link`a0100=A0100`flag=infoself&etoken=" + etoken;
                        //0qa%2FocX0MDkxMCw5OTk5MTIzMTAwMDA%3D
                        reportVO.setUrl(url);
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        page.setRecords(vos);

        return CommonResponse.success("查询列表数据成功！", page);

    }

    /**
     * @param param
     * @Description queryUnderReport 查询欠薪台账
     */
    @RequestMapping(value = "/queryUnderReport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<UnderReportVO>> queryUnderReport(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("org_name");
        /**
         * 组织隔离
         */
        //普通组织 id
//        List<OrgVO> orgVOList = null;
//        List<String> orgCodes = new ArrayList<>();
//        if(!param.getParams().containsKey("orgId")) {
//            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
//        } else {
//            Long orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
//            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
//        }
//        orgVOList.stream().forEach(org -> {
//            //普通组织
//            orgCodes.add(org.getCode());
//        });
//        if (CollectionUtils.isNotEmpty(orgCodes)) {
//            /** 要求主表有orgId字段，保存单据所属组织 */
//            param.getParams().put("orgCode", new Parameter(QueryParam.IN, orgCodes));
//            param.getParams().remove("orgId");
//        }

        param.getOrderMap().put("orgCode", "asc");
        param.getOrderMap().put("year", "asc");
        param.getOrderMap().put("month", "asc");
        /**
         *实现分页
         */
        Page<UnderReportVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);

        page.setRecords(service.queryUnderReport(page, wrapper));

        return CommonResponse.success("查询列表数据成功！", page);

    }

    /**
     * @param param
     * @Description queryUnderReport 查询单位欠薪统计
     */
    @RequestMapping(value = "/queryOrgUnder", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<UnderReportVO>> queryOrgUnder(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("org_name");
        /**
         * 组织隔离
         */
        //普通组织 id
//        List<OrgVO> orgVOList = null;
//        List<String> orgCodes = new ArrayList<>();
//        if(!param.getParams().containsKey("orgId")) {
//            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
//        } else {
//            Long orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
//            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
//        }
//        orgVOList.stream().forEach(org -> {
//            //普通组织
//            orgCodes.add(org.getCode());
//        });
//        if (CollectionUtils.isNotEmpty(orgCodes)) {
//            /** 要求主表有orgId字段，保存单据所属组织 */
//            param.getParams().put("orgCode", new Parameter(QueryParam.IN, orgCodes));
//            param.getParams().remove("orgId");
//        }

        param.getOrderMap().put("orgCode", "asc");
        /**
         *实现分页
         */
        Page<UnderReportVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);

        page.setRecords(service.queryOrgUnder(page, wrapper));

        return CommonResponse.success("查询列表数据成功！", page);

    }

    /**
     * @param param
     * @Description queryUnderReport 查询单位欠薪统计
     */
    @RequestMapping(value = "/queryOrgUnderNum", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<UnderReportVO>> queryOrgUnderNum(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("org_name");
        param.getOrderMap().put("orgCode", "asc");

        if (param.getParams().containsKey("num")) {
            String flag = param.getParams().get("num").getValue().toString();
            if ("4".equals(flag)) {
                param.getParams().remove("num");
                param.getParams().put("num", new Parameter(QueryParam.SQL, "num > 3"));
            }
        }
        /**
         *实现分页
         */
        Page<UnderReportVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);

        page.setRecords(service.queryOrgUnderNum(page, wrapper));

        return CommonResponse.success("查询列表数据成功！", page);

    }


    /**
     * @param param
     * @Description queryOrgPayReport 查询单位薪酬明细
     */
    @RequestMapping(value = "/queryOrgPayReport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryOrgPayReport(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("org_name");
        param.getOrderMap().put("orgCode", "asc");

        /**
         * 组织隔离
         */
        //普通组织 id
        List<OrgVO> orgVOList = new ArrayList<>();
        List<String> orgCodes = new ArrayList<>();
        if (!param.getParams().containsKey("orgId")) {
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        } else {
            Long orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
        }
        orgVOList.stream().forEach(org -> {
            //普通组织
            orgCodes.add(org.getCode());
        });
        if (CollectionUtils.isNotEmpty(orgCodes)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgCode", new Parameter(QueryParam.IN, orgCodes));
            param.getParams().remove("orgId");
        }


        /**
         *实现分页
         */
        Page<OrgPayReportVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);

        page.setRecords(service.queryOrgPayReport(page, wrapper));

        //页面右上角统计数据
        param.getOrderMap().clear();
        QueryWrapper wrapper1 = BaseServiceImpl.changeToQueryWrapper(param);
        OrgPayReportVO orgPayReportVO = service.queryOrgPayReportSum( wrapper1);


        com.alibaba.fastjson.JSONObject pageData = new com.alibaba.fastjson.JSONObject();
        pageData.put("records", page.getRecords());
        pageData.put("total", page.getTotal());
        pageData.put("current", page.getCurrent());
        pageData.put("size", page.getSize());
        pageData.put("pages", page.getPages());
        pageData.put("avgMnyTotal", orgPayReportVO.getAvgMnyTotal());
        pageData.put("mnyTotalNew", orgPayReportVO.getTotalMny());
        pageData.put("numSum",  orgPayReportVO.getNum());

        return CommonResponse.success("查询单位薪酬明细！", pageData);

    }


    /**
     * @param param
     * @Description querySalaryDetail 查询单位薪资总额
     */
    @RequestMapping(value = "/queryOrgSalarySum", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SalaryDetailVO>> queryOrgSalarySum(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /**
         * 组织隔离
         */
        boolean orgTypeFlag = false;
        //普通组织 id
        List<OrgVO> orgVOList = new ArrayList<>();
        List<String> orgCodes = new ArrayList<>();
        if (param.getParams().containsKey("orgId") && param.getParams().get("orgId").getValue() != null) {
            Long orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
            if(param.getParams().containsKey("orgType")){
                String orgType = param.getParams().get("orgType").getValue().toString();
                if (!"5".equals(orgType)){//不是项目
                    orgTypeFlag = true;
                }
            } else {
                orgTypeFlag = true;
            }
        } else {
            String orgType = InvocationInfoProxy.getOrgType();
            if (!"5".equals(orgType)){//不是项目
                orgTypeFlag = true;
            }
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        if(param.getParams().containsKey("ignore")){
            param.getParams().remove("ignore");
            List<OrgVO> ignoreOrgVOList =  (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(ignoreOrgIds), true,"查询过滤掉组织失败，获取当前本下组织信息失败。");
            List<String> ignoreOrgCodes = new ArrayList<>();
            ignoreOrgVOList.stream().forEach(org -> {
                //普通组织
                ignoreOrgCodes.add(org.getCode());
            });
            orgVOList = orgVOList.stream().filter(s-> !ignoreOrgCodes.contains(s.getCode())).collect(Collectors.toList());
        }
        orgVOList.stream().forEach(org -> {
            //普通组织
            orgCodes.add(org.getCode());
        });

        if(param.getParams().containsKey("departmentCode") && param.getParams().get("departmentCode").getValue() != null){
            param.getParams().remove("orgId");

        } else {
            if (CollectionUtils.isNotEmpty(orgCodes)) {
                /** 要求主表有orgId字段，保存单据所属组织 */
                if(orgTypeFlag) {
                    param.getParams().put("orgCode", new Parameter(QueryParam.IN, orgCodes));
                }else {
                    param.getParams().put("departmentCode", new Parameter(QueryParam.IN, orgCodes));
                }
                param.getParams().remove("orgId");
                param.getParams().remove("orgType");
            }
        }



        /**
         *实现分页
         */
        Page<SalaryDetailVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);
        List<SalaryDetailVO> salaryDetailVOS = service.queryOrgSalarySum(wrapper);



        page.setRecords(salaryDetailVOS);

        return CommonResponse.success("查询人员薪酬明细成功！", page);

    }

    /**
     * @param param
     * @Description querySalaryDetail 查询人员薪酬明细
     */
    @RequestMapping(value = "/querySalaryDetail", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> querySalaryDetail(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("org_name");
        fuzzyFields.add("department_name");
        fuzzyFields.add("name");
        fuzzyFields.add("ac_set");
        fuzzyFields.add("salary_org_name");
        param.getOrderMap().put("orgSequence", "asc");
        param.getOrderMap().put("departmentSequence", "asc");
        param.getOrderMap().put("employeeSequence", "asc");

        /**
         * 组织隔离
         */
        boolean orgTypeFlag = false;
        //普通组织 id
        List<OrgVO> orgVOList = new ArrayList<>();
        List<String> orgCodes = new ArrayList<>();
        if (param.getParams().containsKey("orgId") && param.getParams().get("orgId").getValue() != null) {
            Long orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
            if(param.getParams().containsKey("orgType")){
                String orgType = param.getParams().get("orgType").getValue().toString();
                if (!"5".equals(orgType)){//不是项目
                    orgTypeFlag = true;
                }
            }
        } else {
            String orgType = InvocationInfoProxy.getOrgType();
            if (!"5".equals(orgType)){//不是项目
                orgTypeFlag = true;
            }
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        if(param.getParams().containsKey("ignore")){
            param.getParams().remove("ignore");
            List<OrgVO> ignoreOrgVOList =  (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(ignoreOrgIds), true,"查询过滤掉组织失败，获取当前本下组织信息失败。");
            List<String> ignoreOrgCodes = new ArrayList<>();
            ignoreOrgVOList.stream().forEach(org -> {
                //普通组织
                ignoreOrgCodes.add(org.getCode());
            });
            orgVOList = orgVOList.stream().filter(s-> !ignoreOrgCodes.contains(s.getCode())).collect(Collectors.toList());
        }
        orgVOList.stream().forEach(org -> {
            //普通组织
            orgCodes.add(org.getCode());
        });

        if(param.getParams().containsKey("departmentCode") && param.getParams().get("departmentCode").getValue() != null){
            param.getParams().remove("orgId");

        } else {
            if (CollectionUtils.isNotEmpty(orgCodes)) {
                /** 要求主表有orgId字段，保存单据所属组织 */
                if(orgTypeFlag) {
                    param.getParams().put("orgCode", new Parameter(QueryParam.IN, orgCodes));
                }else {
                    param.getParams().put("departmentCode", new Parameter(QueryParam.IN, orgCodes));
                }
                param.getParams().remove("orgId");
                param.getParams().remove("orgType");
            }
        }



        /**
         *实现分页
         */
        Page<SalaryDetailVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);
        List<SalaryDetailVO> salaryDetailVOS = service.querySalaryDetail(page, wrapper);
        /**
         * url etoken生成并放入VO返回
         */
        for (SalaryDetailVO vo : salaryDetailVOS) {
            //通过建造师编号查询员工信息
            CommonResponse<UserVO> userVO = userApi.queryUserByUserCode(vo.getUserCode());
            if (userVO != null) {
                try {
                    UserVO userVOData = userVO.getData();
                    if (userVOData != null) {
                        String userCode = userVOData.getUserCode();
                        //登录账号+,999912310000
                        userCode = userCode + ",999912310000";
                        //BASE64 GBK编码在URL GBK编码
                        String etoken = URLEncoder.encode(Base64Method.EncryptBase64(userCode), "GBK");
                        String url = "http://hr.zzyjjt.com/templates/index/ssoiframe.jsp?url=/workbench/browse/showselfinfo.do?b_search=link`a0100=A0100`flag=infoself&etoken=" + etoken;
                        //0qa%2FocX0MDkxMCw5OTk5MTIzMTAwMDA%3D
                        vo.setUrl(url);
                    }

                } catch (Exception e) {
                    e.printStackTrace();
                }
            }

        }


        page.setRecords(salaryDetailVOS);
        //页面右上角统计数据
        param.getOrderMap().clear();
        QueryWrapper wrapper1 = BaseServiceImpl.changeToQueryWrapper(param);
        List<SalaryDetailVO> sumVOS = service.queryOrgSalarySum(wrapper1);


        com.alibaba.fastjson.JSONObject pageData = new com.alibaba.fastjson.JSONObject();
        pageData.put("records", page.getRecords());
        pageData.put("total", page.getTotal());
        pageData.put("current", page.getCurrent());
        pageData.put("size", page.getSize());
        pageData.put("pages", page.getPages());
        if(ListUtil.isNotEmpty(sumVOS)){

            pageData.put("shouldSalaryMny", sumVOS.get(0).getShouldSalaryMny());
            pageData.put("totalOrgSocialMny", sumVOS.get(0).getTotalOrgSocialMny());
            pageData.put("totalOrgFundMny", sumVOS.get(0).getTotalOrgFundMny());
//            pageData.put("workOverTimeMny", sumVOS.get(0).getWorkOverTimeMny());
            pageData.put("totalOrgCostMny",
                    sumVOS.get(0).getShouldSalaryMny()
                            .add(sumVOS.get(0).getTotalOrgSocialMny ())
                            .add(sumVOS.get(0).getTotalOrgFundMny())
//                            .add(sumVOS.get(0).getWorkOverTimeMny())

            );
        }
        return CommonResponse.success("查询人员薪酬明细成功！", pageData);

    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }
}
