/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.hr.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.hr.service.IBaseOrgService;
import com.ejianc.business.hr.vo.OrgDataVO;
import com.ejianc.business.hr.vo.hrm.UserJobVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"baseOrg"})
public class BaseOrgController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IBaseOrgService service;

    @RequestMapping(value={"/refAllOrgData"}, method={RequestMethod.GET})
    @ResponseBody
    public List<OrgDataVO> refAllOrgData(@RequestParam(required=false) String searchText, String condition) {
        List<OrgDataVO> dataList = null;
        long start = System.currentTimeMillis();
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            if (StringUtils.isNotBlank((CharSequence)condition)) {
                JSONObject _con = JSONObject.parseObject((String)condition);
                String type = _con.getString("type");
                if (!StringUtils.isNotBlank((CharSequence)type)) {
                    throw new BusinessException("\u53c2\u6570\u9519\u8bef,\u7c7b\u578b\u5fc5\u586b");
                }
                params.put("type", type);
                String parentId = _con.getString("parentId");
                if (StringUtils.isNotBlank((CharSequence)parentId)) {
                    params.put("parentId", parentId);
                }
            } else {
                throw new BusinessException("\u53c2\u6570\u9519\u8bef,\u7c7b\u578b\u5fc5\u586b");
            }
            if (StringUtils.isNotBlank((CharSequence)searchText)) {
                params.put("searchText", searchText);
            }
            params.put("tenantId", InvocationInfoProxy.getTenantid());
            dataList = this.service.refAllOrgData(params);
            System.out.println("\u67e5\u8be2\u8017\u65f6:" + (System.currentTimeMillis() - start));
            if (dataList != null && dataList.size() > 0) {
                List<OrgDataVO> resultList = this.createTreeData(dataList);
                System.out.println("\u603b\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
                return resultList;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @RequestMapping(value={"/refAllDictData"}, method={RequestMethod.GET})
    @ResponseBody
    public List<OrgDataVO> refAllDictData(@RequestParam(required=false) String searchText, String condition) {
        List<OrgDataVO> dataList = null;
        long start = System.currentTimeMillis();
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            if (StringUtils.isNotBlank((CharSequence)condition)) {
                JSONObject _con = JSONObject.parseObject((String)condition);
                String type = _con.getString("type");
                if (!StringUtils.isNotBlank((CharSequence)type)) {
                    throw new BusinessException("\u53c2\u6570\u9519\u8bef,\u7c7b\u578b\u5fc5\u586b");
                }
                params.put("type", type);
                String parentId = _con.getString("parentId");
                if (StringUtils.isNotBlank((CharSequence)parentId)) {
                    params.put("parentId", parentId);
                }
            } else {
                throw new BusinessException("\u53c2\u6570\u9519\u8bef,\u7c7b\u578b\u5fc5\u586b");
            }
            if (StringUtils.isNotBlank((CharSequence)searchText)) {
                params.put("searchText", searchText);
            }
            params.put("tenantId", InvocationInfoProxy.getTenantid());
            dataList = this.service.refAllDictData(params);
            System.out.println("\u67e5\u8be2\u8017\u65f6:" + (System.currentTimeMillis() - start));
            if (dataList != null && dataList.size() > 0) {
                List<OrgDataVO> resultList = this.createTreeData(dataList);
                System.out.println("\u603b\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
                return resultList;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public List<OrgDataVO> createTreeData(List<OrgDataVO> list) {
        ArrayList<OrgDataVO> resp = new ArrayList<OrgDataVO>();
        ArrayList<String> rootItems = new ArrayList<String>();
        HashMap<String, OrgDataVO> listMap = new HashMap<String, OrgDataVO>();
        for (OrgDataVO dataVO : list) {
            if (dataVO.getId().equals(dataVO.getParentId())) {
                dataVO.setParentId(null);
            }
            listMap.put(dataVO.getId().toString(), dataVO);
        }
        for (int i = 0; i < list.size(); ++i) {
            OrgDataVO dataVO;
            dataVO = list.get(i);
            String parentId = dataVO.getParentId() == null ? "" : dataVO.getParentId();
            OrgDataVO parent = (OrgDataVO)listMap.get(parentId);
            if (parent != null) {
                List child = parent.getChildren();
                if (child != null) {
                    child.add(dataVO);
                    continue;
                }
                ArrayList<OrgDataVO> children = new ArrayList<OrgDataVO>();
                children.add(dataVO);
                parent.setChildren(children);
                continue;
            }
            rootItems.add(dataVO.getId().toString());
        }
        for (String rootId : rootItems) {
            resp.add((OrgDataVO)listMap.get(rootId));
        }
        return resp;
    }

    @RequestMapping(value={"/refPartTimeUserList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<UserJobVO>> refPartTimeUserList(@RequestParam(required=false) String userCode, @RequestParam(required=false) String jobState) {
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", this.service.refPartTimeUserList(userCode, jobState));
    }
}

