package com.ejianc.business.hr.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.desktop.api.IShareCategoryApi;
import com.ejianc.business.hr.service.IBaseOrgService;
import com.ejianc.business.hr.service.IBaseUserService;
import com.ejianc.business.hr.utils.Base64Method;
import com.ejianc.business.hr.vo.*;
import com.ejianc.business.hr.vo.hrm.UserJobVO;
import com.ejianc.business.hr.vo.salarySystem.SalaryAttendanceDataVO;
import com.ejianc.business.hr.vo.salarySystem.SalaryJobDataVO;
import com.ejianc.business.hr.vo.salarySystem.SalaryTransferDataVO;
import com.ejianc.business.hr.vo.salarySystem.SalaryUserDataVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.Utils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 人力基础人员信息
 *
 * @author generator
 */
@Controller
@RequestMapping("baseOrg")
public class BaseOrgController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IBaseOrgService service;



    @RequestMapping(value = "/refAllOrgData", method = RequestMethod.GET)
    @ResponseBody
    public List<OrgDataVO> refAllOrgData(@RequestParam(required = false) String searchText,
                                          String condition) {
        List<OrgDataVO> dataList = null;
        long start = System.currentTimeMillis();
        try {
            Map<String,Object> params = new HashMap<>();
            if(StringUtils.isNotBlank(condition)) {
                JSONObject _con = JSONObject.parseObject(condition);

                String type = _con.getString("type");
                if(StringUtils.isNotBlank(type)){
                    params.put("type", type);
                }else {
                    throw new BusinessException("参数错误,类型必填");
                }

                String parentId = _con.getString("parentId");
                if(StringUtils.isNotBlank(parentId)) {
                    params.put("parentId", parentId);
                }
            }else {
                throw new BusinessException("参数错误,类型必填");
            }

            if(StringUtils.isNotBlank(searchText)) {
                params.put("searchText", searchText);
            }
            params.put("tenantId", InvocationInfoProxy.getTenantid());
            dataList = service.refAllOrgData(params);
            System.out.println("查询耗时:"+(System.currentTimeMillis()-start));
            if(dataList != null && dataList.size() > 0) {
                List<OrgDataVO> resultList = createTreeData(dataList);
                System.out.println("总耗时："+(System.currentTimeMillis()-start));
                return resultList;
            }
        } catch (Exception e) {}
        return null;
    }
    @RequestMapping(value = "/refAllDictData", method = RequestMethod.GET)
    @ResponseBody
    public List<OrgDataVO> refAllDictData(@RequestParam(required = false) String searchText,
                                          String condition) {
        List<OrgDataVO> dataList = null;
        long start = System.currentTimeMillis();
        try {
            Map<String,Object> params = new HashMap<>();
            if(StringUtils.isNotBlank(condition)) {
                JSONObject _con = JSONObject.parseObject(condition);

                String type = _con.getString("type");
                if(StringUtils.isNotBlank(type)){
                    params.put("type", type);
                }else {
                    throw new BusinessException("参数错误,类型必填");
                }

                String parentId = _con.getString("parentId");
                if(StringUtils.isNotBlank(parentId)) {
                    params.put("parentId", parentId);
                }
            }else {
                throw new BusinessException("参数错误,类型必填");
            }

            if(StringUtils.isNotBlank(searchText)) {
                params.put("searchText", searchText);
            }
            params.put("tenantId", InvocationInfoProxy.getTenantid());
            dataList = service.refAllDictData(params);
            System.out.println("查询耗时:"+(System.currentTimeMillis()-start));
            if(dataList != null && dataList.size() > 0) {
                List<OrgDataVO> resultList = createTreeData(dataList);
                System.out.println("总耗时："+(System.currentTimeMillis()-start));
                return resultList;
            }
        } catch (Exception e) {}
        return null;
    }

    public List<OrgDataVO> createTreeData(List<OrgDataVO> list) {
        List<OrgDataVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();
        Map<String, OrgDataVO> listMap = new HashMap<>();
        for(OrgDataVO dataVO:list) {
            if(dataVO.getId().equals(dataVO.getParentId())) {
                dataVO.setParentId(null);
            }
            listMap.put(dataVO.getId().toString(), dataVO);
        }

        for(int i =0; i<list.size(); i++) {
            OrgDataVO dataVO = list.get(i);
            String parentId = dataVO.getParentId() == null ? "" : dataVO.getParentId();
            OrgDataVO parent = listMap.get(parentId);
            if(parent != null) {
                List<OrgDataVO> child = parent.getChildren();
                if(child != null) {
                    child.add(dataVO);
                }else{
                    List<OrgDataVO> children = new ArrayList<OrgDataVO>();
                    children.add(dataVO);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(dataVO.getId().toString());
            }
        }

        for(String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }


    /**
     * 人员兼职清单查询
     */
    @RequestMapping(value = "/refPartTimeUserList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<UserJobVO>> refPartTimeUserList(@RequestParam(required = false) String userCode,
                                               @RequestParam(required = false) String jobState) {
        return CommonResponse.success("查询列表数据成功！", service.refPartTimeUserList(userCode, jobState));
    }

}
