package com.ejianc.business.hr.mapper;

import com.ejianc.business.hr.bean.BaseUserEntity;
import com.ejianc.business.hr.vo.salarySystem.SalaryAttendanceDataVO;
import com.ejianc.business.hr.vo.salarySystem.SalaryJobDataVO;
import com.ejianc.business.hr.vo.salarySystem.SalaryTransferDataVO;
import com.ejianc.business.hr.vo.salarySystem.SalaryUserDataVO;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;

import java.util.List;

/**
 * 人力基础人员信息
 *
 * @author generator
 */
@Mapper
public interface SalaryUserMapper extends BaseCrudMapper<BaseUserEntity> {
    /**
     * 查询人员信息-薪资系统 -- 全量
     * @return
     */
    List<SalaryUserDataVO> queryAllUserSalary();


    /**
     *
     *薪资系统获取兼职信息--全量
     * @return
     */
    List<SalaryJobDataVO> queryAllJobSalary();

    /**
     *
     *薪资系统获取考勤信息 -- 按照更新时间近三天
     * @return
     */
    List<SalaryAttendanceDataVO> queryAllAttendanceSalary();

    /**
     *
     *薪资系统获取异动信息-- 按照更新时间近三天
     * @return
     */
    List<SalaryTransferDataVO> queryAllTransferSalary();
}
