package com.ejianc.business.hr.service.impl;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.hr.bean.BaseOrgEntity;
import com.ejianc.business.hr.mapper.BaseOrgMapper;
import com.ejianc.business.hr.mapper.UserChangeMapper;
import com.ejianc.business.hr.service.IBaseOrgService;
import com.ejianc.business.hr.service.IUserChangeService;
import com.ejianc.business.hr.vo.OrgDataVO;
import com.ejianc.business.hrm.vo.UserChangeJobDetailVO;
import com.ejianc.business.hrm.vo.UserChangeVO;
import com.ejianc.business.proequipmentcorpout.util.DateUtil;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.List;
import java.util.Map;

/**
 * 人力基础人员信息
 *
 * @author generator
 */
@Service("hrUserChangeService")
public class UserChangeServiceImpl extends BaseServiceImpl<UserChangeMapper, BaseOrgEntity> implements IUserChangeService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private UserChangeMapper mapper;


    @Override
    public String userChangeEffect(UserChangeVO vo) {
        /**
         * 1.保存修改ABE
         */

        //获取最大的I9999
        String maxI9999 = mapper.getMaxI9999("UsrABE","A0100",vo.getUserCode());
        maxI9999 = maxI9999 == null ? "1" : maxI9999;
        //修改异动结束时间为空的数据
        mapper.updateAbeEndTime(vo.getChangeTime(), vo.getUserCode());
        logger.info("abe修改异动结束时间为空数据：{}",vo.getUserCode());
        //单位内调动不需修改A19   25-12-10改为全部需要修改工作经历
        mapper.updateA19EndTime(vo.getChangeTime(), vo.getUserCode());
        logger.info("A19修改结束时间为空数据：{}",vo.getUserCode());

        //增加一条新的异动信息
        Calendar cal = Calendar.getInstance();
        cal.setTime(vo.getChangeTime());
        cal.add(Calendar.DATE, 1); //
        vo.setChangeTime(cal.getTime());
        //拼接单位+部门 赋值单位
        vo.setNewOrgName(vo.getNewOrgName()+vo.getNewDeptName());
        vo.setOldOrgName(vo.getOldOrgName()+vo.getOldDeptName());
        mapper.insertAbe(vo,maxI9999);
        logger.info("abe增加一条新的异动信息：{}",vo.getUserCode());

        //单位内调动不需修改A19   25-12-10改为全部需要修改工作经历
        /**
         * 2.保存修改A19工作经历
         */
        //获取最大的I9999
        String maxI99991 = mapper.getMaxI9999("UsrA19", "A0100", vo.getUserCode());
        maxI99991 = maxI99991 == null ? "1" : maxI99991;
        //修改异动结束时间为空的上一条数据-- 放到上边修改，此处时间已经改过了
        mapper.insertA19(vo, maxI99991);
        logger.info("A19增加一条新的工作经历：{}",vo.getUserCode());


//        //单位间调动需修改A09，把所有兼职免掉
//        if("3".equals(vo.getChangeTypeCode())) {
//            mapper.updateA09(vo);
//            logger.info("A09修改兼职改为免职：{}",vo.getUserCode());
//        }
        //兼职根据子表数据进行修改，而不是全部免职
        List<UserChangeJobDetailVO> userChangeJobDetailList = vo.getUserChangeJobDetailList();
        if(CollectionUtils.isNotEmpty(userChangeJobDetailList)){
            for (UserChangeJobDetailVO userChangeJobDetailVO : userChangeJobDetailList) {
                mapper.updateA09JobState(userChangeJobDetailVO);
            }
        }

        /**
         * 3.保存修改A01
         */
        mapper.updateA01(vo);
        logger.info("A01保存修改A01：{}",vo.getUserCode());
        return "异动数据处理完成！";
    }
}
