package com.ejianc.foundation.permission.api;

import java.util.List;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import com.ejianc.foundation.permission.hystrix.RoleHystrix;
import com.ejianc.foundation.permission.vo.RoleUserRelationVO;
import com.ejianc.foundation.permission.vo.RoleVO;
import com.ejianc.framework.core.response.CommonResponse;

/**
 * 角色rpc服务
 * 
 * @author cJ
 *
 */
@FeignClient(name= "ejc-idm-web", url="${common.env.feign-client-url}", path="ejc-idm-web", fallback = RoleHystrix.class)
public interface IRoleApi {

	/**
	 * 查询角色下的用户
	 *
	 * @param 
	 * @return
	 */
	@GetMapping(value = "/api/roleApi/getRoleUser")
    CommonResponse<List<RoleUserRelationVO>> getRoleUser(@RequestParam(value = "roleId") List<Long> roleId, @RequestParam(value = "authOrgId", required = false) List<Long> authOrgId);


	/**
	 * 查询用户下的角色
	 *
	 * @param 
	 * @return
	 */
	@GetMapping("/api/roleApi/queryRoleIdsByUserId")
    CommonResponse<List<Long>> queryRoleIdsByUserId(@RequestParam(value = "userId") Long userId);

	/**
	 * 查询用户下的角色
	 *
	 * @param 
	 * @return
	 */
	@GetMapping("/api/roleApi/queryRoleByUserId")
    CommonResponse<List<RoleVO>> queryRoleByUserId(@RequestParam(value = "userId") Long userId);


	/**
	 * 根据用户查询用户挂载角色下的应用下挂载的单据类型所属的模块ids
	 *
	 * @param
	 * @return
	 */
	@GetMapping("/api/roleApi/queryModelIdsByUserId")
	CommonResponse<List<Long>> queryModelIdsByUserId(@RequestParam(value = "userId") Long userId);

	/**
	 * 根据用户查询用户挂载角色下的应用下挂载的单据类型ids
	 *
	 * @param
	 * @return
	 */
	@GetMapping("/api/roleApi/queryBillTypeIdsByUserId")
	CommonResponse<List<Long>> queryBillTypeIdsByUserId(@RequestParam(value = "userId") Long userId);

	/**
	 * 根据角色名称和编码查询角色信息
	 *
	 * @param
	 * @return
	 */
	@GetMapping("/api/roleApi/queryRoleByNameAndCode")
	CommonResponse<List<RoleVO>> queryRoleByNameAndCode(@RequestParam(value = "name", required=false)String name,
														  @RequestParam(value = "code", required=false) String code);

}
