package com.ejianc.foundation.orgcenter.api;

import com.alibaba.fastjson.JSONArray;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import com.ejianc.foundation.orgcenter.hystrix.EmployeeHystrix;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.framework.core.response.CommonResponse;

import java.util.List;
import java.util.Map;

/**
 * 人员管理微服务
 * 
 * @author guoming
 *
 */
@FeignClient(name= "ejc-idm-web", url="${common.env.feign-client-url}", path="ejc-idm-web", fallback = EmployeeHystrix.class)
public interface IEmployeeApi {

	@RequestMapping(value = "/api/employee/getByUserId", method=RequestMethod.GET)
    CommonResponse<EmployeeVO> queryEmployeByUserId(@RequestParam(value = "userId") Long userId);

	/**
	 * 项目部成员管理
	 * @param memberInfo
	 * @return
	 */
	@PostMapping(value = "api/employee/manageProjectMembers")
    CommonResponse<String> manageProjectMembers(@RequestBody Map<String, Object> memberInfo);


	/**
	 * 项目部成员管理
	 * @param memberInfo
	 * @return
	 */
	@PostMapping(value = "api/employee/manageUpdateProjectMembers")
	CommonResponse<String> manageUpdateProjectMembers(@RequestBody Map<String, Object> memberInfo);

	/**
	 * @Author mrsir_wxp
	 * @Date 2021/3/10 根据用户id查询用户主兼职组织id
	 * @Description getJobOrgIdsByUserId
	 * @Param [userId]
	 * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.foundation.orgcenter.vo.EmployeeVO>
	 */
	@RequestMapping(value = "api/employee/getJobOrgIdsByUserId", method=RequestMethod.GET)
    CommonResponse<List<Long>> getJobOrgIdsByUserId(@RequestParam(value = "userId") Long userId, @RequestParam(value = "tenantId") Long tenantId);

	@RequestMapping(value = "/api/employee/getById", method=RequestMethod.GET)
    CommonResponse<EmployeeVO> getById(@RequestParam(value = "id") Long id);

	/**
	 * 此方法关联查询人员任职、部门、岗位、租户关系等数据
	 * */
	@PostMapping(value = "/api/employee/getByIds")
    CommonResponse<List<EmployeeVO>> getByIds(@RequestBody List<Long> ids);

	/**
	 * 此方法仅以人员id查询人员表数据,不关联租户、组织、部门、岗位、
	 * */
	@PostMapping(value = "/api/employee/getJustByIds")
    CommonResponse<List<EmployeeVO>> getJustByIds(@RequestBody List<Long> ids);

	/**
	 * 根据员工编码查询员工详情
	 * 
	 * @param employeeCode
	 * @return
	 */
	@RequestMapping(value = "/api/employee/getByEmployeeCode", method=RequestMethod.GET)
    CommonResponse<EmployeeVO> getByEmpmloyeeCode(@RequestParam(value = "emplmoyeeCode") String employeeCode);

	/**
	 * 根据员工编码查询员工详情
	 *
	 * @param employeeCodes
	 * @return
	 */
	@PostMapping(value = "/api/employee/getAllByEmployeeCodes")
    CommonResponse<List<EmployeeVO>> getAllByEmployeeCodes(@RequestBody List<String> employeeCodes);


	/**
	 * 修改人员类别
	 * @param memberInfo
	 * @return
	 */
	@PostMapping(value = "api/employee/updateJobType")
	CommonResponse<String> updateJobType(@RequestBody Map<String, Object> memberInfo);

	/**
	 * 批量查询某些组织下的某些岗位人员列表，返回结果根据组织+岗位剔重
	 * @Author weixh  add by 20220728
	 * @param orgIds
	 * @param postIds
	 * @return
	 */
	@GetMapping("api/employee/queryEmployeeByPostAndOrg")
	public CommonResponse<List<EmployeeVO>> queryEmployeeByPostAndOrg(@RequestParam(value = "postIds") List<Long> postIds, @RequestParam(value = "orgIds") List<Long> orgIds);

	/**
	 * 批量查询某些组织下的某些岗位人员列表，返回结果根据组织+岗位剔重
	 * @Author yqls  add by 20230620
	 * @param postInfo
	 * @return
	 */
	@PostMapping("api/employee/queryByPostAndOrg")
	public CommonResponse<List<EmployeeVO>> queryByPostAndOrg(@RequestBody Map<String, List<Long>> postInfo);

	/**
	 * 根据员工编码或员工身份证批量查询员工详情
	 *
	 * @param codeOrIdcard
	 * @return
	 */
	@RequestMapping(value = "/api/employee/getByCodeOrIdcard", method=RequestMethod.GET)
	public CommonResponse<List<EmployeeVO>> getByCodeOrIdcard(@RequestParam(value = "codeOrIdcard") List<String> codeOrIdcard);

	@GetMapping("api/employee/queryByDeptCode")
	public CommonResponse<List<EmployeeVO>> queryEmployeeByDeptCode(@RequestParam(value = "deptCode") String deptCode);

	@GetMapping("api/employee/getOneBySourceId")
	public CommonResponse<EmployeeVO> getOneBySourceId(@RequestParam("sourceId") String sourceId);

	@PostMapping("api/employee/getAllBySourceIds")
	public CommonResponse<List<EmployeeVO>> getAllBySourceIds(@RequestBody List<String> sourceIds);

	/** 中电四项目人员 兼职接口*/
	@PostMapping(value = "api/employee/partJobBeachForZd4")
	CommonResponse<String> partJobBeachForZd4(@RequestBody JSONArray array);
}
