package com.ejianc.foundation.orgcenter.api;

import com.ejianc.foundation.orgcenter.hystrix.DeptHystrix;
import com.ejianc.foundation.orgcenter.vo.DeptVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @author CJ
 * @Description:
 * @date 2024/5/15 15:28
 */
@FeignClient(name= "ejc-idm-web", url="${common.env.feign-client-url}", path="ejc-idm-web", fallback = DeptHystrix.class)
public interface IDeptApi {

    /**
     * 查询指定的主键列表对应的部门信息
     *
     * @param deptIds
     * @return
     */
    @PostMapping(value = "/api/dept/getAllByDeptIds")
    CommonResponse<List<DeptVO>> getAllByDeptIds(@RequestBody List<Long> deptIds);

}
