package com.ejianc.foundation.sync.api;

import com.ejianc.foundation.sync.hystrix.ZjwjSyncHystrix;
import com.ejianc.foundation.sync.vo.SyncEmployeeAndUserVO;
import com.ejianc.foundation.sync.vo.SyncJobVO;
import com.ejianc.foundation.sync.vo.SyncOrgAndDeptVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.Date;
import java.util.List;

/**
 * 同步数据的rpc服务
 *
 * @author liyongjia
 *
 */
@FeignClient(name= "ejc-idm-web", url="${common.env.feign-client-url}", path="ejc-idm-web", fallback = ZjwjSyncHystrix.class)
public interface IZjwjSyncApi {


	/**
	 * 获取上次同步组织时间
	 *
	 * @param params
	 * @return
	 */
	@GetMapping(value = "api/zjwjsync/queryLastOrgSyncTime")
	CommonResponse<Date> queryLastOrgSyncTime(@RequestParam(required = false) String params);

	/**
	 * 组织+部门
	 *
	 * @param orgAndDeptVOs
	 * @return
	 */
	@PostMapping(value = "api/zjwjsync/syncOrgList")
	CommonResponse<String> syncOrgList(List<SyncOrgAndDeptVO> orgAndDeptVOs);

	/**
	 * 获取上次同步用户时间
	 *
	 * @param params
	 * @return
	 */
	@GetMapping(value = "api/zjwjsync/queryLastUserSyncTime")
	CommonResponse<Date> queryLastUserSyncTime(@RequestParam(required = false) String params);

	/**
	 * 人员+用户
	 *
	 * @param employeeAndUserVOs
	 * @return
	 */
	@PostMapping(value = "api/zjwjsync/syncEmployeeAndUserList")
	CommonResponse<String> syncEmployeeAndUserList(List<SyncEmployeeAndUserVO> employeeAndUserVOs);

	/**
	 * 获取上次同步任职信息时间
	 *
	 * @param params
	 * @return
	 */
	@GetMapping(value = "api/zjwjsync/queryLastJobSyncTime")
	CommonResponse<Date> queryLastJobSyncTime(@RequestParam(required = false) String params);

	/**
	 * 兼职
	 *
	 * @param jobVO
	 * @return
	 */
	@PostMapping(value = "api/zjwjsync/syncJobList")
	CommonResponse<String> syncJobList(@RequestBody List<SyncJobVO> jobVO);
}
