package com.ejianc.foundation.usercenter.api;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejianc.foundation.usercenter.hystrix.ThirdSystemHystrix;
import com.ejianc.foundation.usercenter.vo.ThirdSystemVO;
import com.ejianc.framework.core.response.CommonResponse;

/**
 * @author CJ
 * @Description:
 * @date 2020/8/6 11:57
 */
@FeignClient(name= "ejc-idm-web", url="${common.env.feign-client-url}", path="ejc-idm-web", fallback = ThirdSystemHystrix.class)
public interface IThirdSystemApi {

    @GetMapping(value = "/no_auth/api/thirdSystem/getOneByCode")
    CommonResponse<ThirdSystemVO> getOneByCode(@RequestParam(value = "code") String code);

    @GetMapping(value = "/no_auth/api/thirdSystem/getYonYouCloudAccessToken")
    CommonResponse<String> getYonYouCloudAccessToken(@RequestParam(value = "reload", required = false, defaultValue = "false") boolean reload);

	/**
	 * 获取钉钉的access_token
	 *
	 * @param appid
	 * @param secret
	 * @return
	 */
	@RequestMapping(value = "/no_auth/api/thirdSystem/getDingDingAccessToken", method = RequestMethod.GET)
	@ResponseBody
    CommonResponse<String> getDingDingAccessToken(@RequestParam(value = "appkey") String appkey,
                                                  @RequestParam(value = "appSecret") String appSecret,
                                                  @RequestParam(value = "refresh", defaultValue = "false", required = false) Boolean refresh);
	
	/**
	 * 群杰物联网平台获取token
	 * 
	 * @param restname
	 * @param password
	 * @param refresh
	 * @return
	 */
	@RequestMapping(value = "/no_auth/api/thirdSystem/getQunjeToken", method = RequestMethod.GET)
	@ResponseBody
	CommonResponse<String> getQunjeToken(@RequestParam(value = "appKey") String appKey,
							             @RequestParam(value = "appSecret") String appSecret,
							             @RequestParam(value = "refresh", defaultValue = "false", required = false) Boolean refresh) ;

	/**
	 * 钉钉第三方企业应用获取accessToken
	 *
	 * @param tenantId
	 * @return
	 */
	@RequestMapping(value = "/no_auth/api/thirdSystem/getDdThirdAppAccessToken", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<String> getDdThirdAppAccessToken(@RequestParam(value = "tenantId") Long tenantId);

	/**
	 * 钉钉第三方企业应用获取应用id（企业不同，应用不同）
	 *
	 * @param corpid
	 * @return
	 */
	@RequestMapping(value = "/no_auth/api/thirdSystem/getDdThirdAgentid", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<String> getDdThirdAgentid(@RequestParam(value = "corpid") String corpid);

	/**
	 * 企业微信第三方企业应用 获取accessToken
	 *
	 * @param corpid
	 * @return
	 */
	@RequestMapping(value = "/no_auth/api/thirdSystem/getWXEEThirdAppAccessToken", method = RequestMethod.GET)
	@ResponseBody
	CommonResponse<String> getWXEEThirdAppAccessToken(@RequestParam(value = "corpid") String corpid);

	/**
	 * 企业微信第三方企业应用 获取agentid
	 *
	 * @param corpid
	 * @return agentid
	 */
	@RequestMapping(value = "/no_auth/api/thirdSystem/getWXEEThirdAgentid", method = RequestMethod.GET)
	@ResponseBody
	CommonResponse<String> getWXEEThirdAgentid(@RequestParam(value = "corpid") String corpid);
}
