package com.ejianc.foundation.wzxtUserProject.vo;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;
import com.ejianc.framework.skeleton.template.BaseVO;

public class WzxtUserProjectRelationVO extends BaseVO {

	private static final long serialVersionUID = 1L;

	private Long userId;

	private Long projectId;

	@SuppressWarnings("unused")
	private String projectName;

	public Long getUserId() {
		return userId;
	}

	public void setUserId(Long userId) {
		this.userId = userId;
	}

	public Long getProjectId() {
		return projectId;
	}

	public void setProjectId(Long projectId) {
		this.projectId = projectId;
	}

	public String getProjectName() {
		try {
			Long project = projectId;
			if(project!=null){
				JSONArray jArray = ReferObjectUtil.getReferEntityValue(project.toString(), "market-project");
				if(jArray!=null&&jArray.size()>0){
					JSONObject json = (JSONObject) jArray.get(0);
					return json.get("name").toString();
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return projectId.toString();
	}

	public void setProjectName(String projectName) {
		this.projectName = projectName;
	}

}