package com.ejianc.foundation.orgcenter.api;

import com.ejianc.foundation.orgcenter.hystrix.OrgNoAuthHystrix;
import com.ejianc.foundation.orgcenter.vo.DeptVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;


/**
 * 组织的rpc服务
 *
 * @author guoming
 *
 */
@FeignClient(name= "ejc-idm-web", url="${common.env.feign-client-url}", path="ejc-idm-web", fallback = OrgNoAuthHystrix.class)
public interface IOrgNoAuthApi {

	/**
	 * 查询匹配的一条组织信息
	 *
	 * @param orgVO
	 * @return
	 */
	@PostMapping(value = "no_auth/api/org/findOneByOrgVO")
    CommonResponse<OrgVO> findOneByOrgVO(@RequestBody OrgVO orgVO);

	/**
	 * 项目部保存服务
	 *
	 * @param orgVO
	 * @return
	 */
	@PostMapping(value = "no_auth/api/org/saveOrgInfo")
	CommonResponse<OrgVO> saveOrgInfo(@RequestBody OrgVO orgVO);

	/**
	 * 部门保存服务
	 *
	 * @param deptVO
	 * @return
	 */
	@PostMapping(value = "no_auth/api/org/saveDeptInfo")
	CommonResponse<String> saveDeptInfo(@RequestBody DeptVO deptVO);
}
