package com.ejianc.foundation.orgcenter.api;

import com.ejianc.foundation.orgcenter.hystrix.PostHystrix;
import com.ejianc.foundation.orgcenter.vo.DeptVO;
import com.ejianc.foundation.orgcenter.vo.PostVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @author CJ
 * @Description:
 * @date 2024/5/15 15:27
 */
@FeignClient(name= "ejc-idm-web", url="${common.env.feign-client-url}", path="ejc-idm-web", fallback = PostHystrix.class)
public interface IPostApi {

    /**
     * 根据岗位Id列表查询匹配的岗位信息
     *
     * @param postIds
     * @return
     */
    @PostMapping(value = "/api/post/getAllByPostIds")
    CommonResponse<List<PostVO>> getAllByPostIds(@RequestBody List<Long> postIds);

}
